package org.gcube.portlets.user.tdcolumnoperation.client;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.user.td.columnwidget.client.properties.ColumnDataProperties;
import org.gcube.portlets.user.td.columnwidget.client.utils.UtilsGXT3;
import org.gcube.portlets.user.td.gwtservice.client.rpc.TDGWTServiceAsync;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTSessionExpiredException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.client.event.SessionExpiredEvent;
import org.gcube.portlets.user.td.widgetcommonevent.client.type.SessionExpiredType;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.tdcolumnoperation.client.rpc.TdColumnOperationServiceAsync;
import org.gcube.portlets.user.tdcolumnoperation.client.specificoperation.ComboColumnDataFunctionPanel;
import org.gcube.portlets.user.tdcolumnoperation.client.specificoperation.GroupByAggregateManager;
import org.gcube.portlets.user.tdcolumnoperation.shared.TdAggregateFunction;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.web.bindery.event.shared.EventBus;
import com.sencha.gxt.core.client.IdentityValueProvider;
import com.sencha.gxt.core.client.Style.SelectionMode;
import com.sencha.gxt.core.client.dom.ScrollSupport.ScrollMode;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.client.loader.RpcProxy;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.event.StoreDataChangeEvent;
import com.sencha.gxt.data.shared.event.StoreDataChangeEvent.StoreDataChangeHandler;
import com.sencha.gxt.data.shared.loader.ListLoadConfig;
import com.sencha.gxt.data.shared.loader.ListLoadResult;
import com.sencha.gxt.data.shared.loader.ListLoadResultBean;
import com.sencha.gxt.data.shared.loader.ListLoader;
import com.sencha.gxt.data.shared.loader.LoadResultListStoreBinding;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutData;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer.VerticalLayoutData;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.TextField;
import com.sencha.gxt.widget.core.client.grid.CheckBoxSelectionModel;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;

/**
 * 
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Jun 10, 2014
 *
 */
public class GroupByColumnPanel extends FramedPanel {
	protected String WIDTH = "640px";
	protected String HEIGHT = "520px";
	protected EventBus eventBus;
	protected TextField label = null;
	protected TRId trId;
	protected String columnName;
	protected ColumnData column;

	protected TextButton groupByButton;

	protected ListLoader<ListLoadConfig, ListLoadResult<ColumnData>> loader;
	protected Grid<ColumnData> grid;
	protected CheckBoxSelectionModel<ColumnData> sm;
	protected FieldLabel columnsSelectLabel;
	

	private VerticalLayoutContainer verticalFunctionsLayout = new VerticalLayoutContainer();
	private List<TdAggregateFunction> aggregationFunctions;
	private GroupByAggregateManager aggreagateFunctionMng = new GroupByAggregateManager();
	

//	protected DeleteColumnSession deleteColumnSession;
//	protected DeleteColumnProgressDialog deleteColumnProgressDialog;
	private ListStore<ColumnData> store;

	public GroupByColumnPanel(TRId trId, String columnName, EventBus eventBus) {
		this.trId = trId;
		this.columnName = columnName;
		this.eventBus = eventBus;
		Log.debug("GroupByColumnPanel(): [" + trId.toString() + " columnName: "
				+ columnName + "]");
		init();
		build();
		
		Scheduler.get().scheduleDeferred(new ScheduledCommand() {

			public void execute() {
				loadAggregateFunctions();

			}
		});
		
		setEnableGroupByButton(false);
	}
	
	public void init(){
		setWidth(WIDTH);
		setHeight(HEIGHT);
		setHeaderVisible(false);
		setBodyBorder(false);
	}

	protected void build() {
		ColumnDataProperties props = GWT.create(ColumnDataProperties.class);

		ColumnConfig<ColumnData, String> labelCol = new ColumnConfig<ColumnData, String>(
				props.label());

		IdentityValueProvider<ColumnData> identity = new IdentityValueProvider<ColumnData>();
		sm = new CheckBoxSelectionModel<ColumnData>(identity);

		List<ColumnConfig<ColumnData, ?>> l = new ArrayList<ColumnConfig<ColumnData, ?>>();
		l.add(sm.getColumn());
		l.add(labelCol);
		ColumnModel<ColumnData> cm = new ColumnModel<ColumnData>(l);

		store = new ListStore<ColumnData>(props.id());

		store.addStoreDataChangeHandler(new StoreDataChangeHandler<ColumnData>() {

			@Override
			public void onDataChange(StoreDataChangeEvent<ColumnData> event) {
				List<ColumnData> cols = event.getSource().getAll();
				Log.debug("Columns:" + cols.size());
				for (ColumnData c : cols) {
					if (c.getName().compareTo(columnName) == 0) {
						sm.select(c, false);
						sm.refresh();
						break;
					}
				}

			}
		});

		RpcProxy<ListLoadConfig, ListLoadResult<ColumnData>> proxy = new RpcProxy<ListLoadConfig, ListLoadResult<ColumnData>>() {

			public void load(ListLoadConfig loadConfig, final AsyncCallback<ListLoadResult<ColumnData>> callback) {
				loadData(loadConfig, callback);
			}
		};
		loader = new ListLoader<ListLoadConfig, ListLoadResult<ColumnData>>(
				proxy);

		loader.setRemoteSort(false);
		loader.addLoadHandler(new LoadResultListStoreBinding<ListLoadConfig, ColumnData, ListLoadResult<ColumnData>>(store) {
		});

		grid = new Grid<ColumnData>(store, cm) {
			@Override
			protected void onAfterFirstAttach() {
				super.onAfterFirstAttach();
				Scheduler.get().scheduleDeferred(new ScheduledCommand() {

					public void execute() {
						loader.load();

					}
				});
			}
		};

		sm.setSelectionMode(SelectionMode.MULTI);
		grid.setLoader(loader);
		grid.setSelectionModel(sm);
		// grid.getView().setAutoExpandColumn(labelCol);
		grid.setHeight(250);
		
//		grid.getView().getHeader().setEnabled(false);
		
		grid.getView().setStripeRows(true);
		grid.getView().setColumnLines(true);
		grid.getView().setAutoFill(true);
		grid.setBorders(false);
		grid.setLoadMask(true);
		grid.setColumnReordering(true);
		grid.setColumnResize(false);

		// Delete Button
		groupByButton = new TextButton("Group By");
		
//		SelectHandler selecteHandler = new SelectHandler() {
//
//			public void onSelect(SelectEvent event) {
//				
//				if(getSelectedItems().size()>0){
//					if(mng ==null){
//						mng = new ColumnDataViewManager(store.getAll(), true);
//						ComboColumnDataFunctionPanel function = new ComboColumnDataFunctionPanel(1, mng.getColumnsData(), aggregationFunctions);
//						verticalFunctionsLayout.add(function.getPanel());
//					}
//					
//					verticalFunctionsLayoutEnable(true);
//				}else
//					verticalFunctionsLayoutEnable(false);
//				
//				onGroupByColumn();
//
//			}
//		};
		
		
		sm.addSelectionHandler(new SelectionHandler<ColumnData>() {
			
			@Override
			public void onSelection(SelectionEvent<ColumnData> event) {
				if(getSelectedItems().size()>0){
					verticalFunctionsLayoutEnable(true);
					setEnableGroupByButton(true);
				}else{
					verticalFunctionsLayoutEnable(false);
					setEnableGroupByButton(false);
				}
				onGroupByColumn();
				
			}
		});

		FieldLabel columnsLabel = new FieldLabel(null, "Group By Column/s");
//		columnsLabel.getElement().applyStyles("font-weight:bold");
		columnsLabel.setLabelWidth(150);

		VerticalLayoutContainer v = new VerticalLayoutContainer();
		v.setScrollMode(ScrollMode.AUTO);
		v.add(columnsLabel, new VerticalLayoutData(1, -1, new Margins(2, 1, 5,1)));
		v.add(grid, new VerticalLayoutData(1, -1, new Margins(0)));
		
		verticalFunctionsLayout.add(new FieldLabel(null, "Aggregate For"), new VerticalLayoutData(1, -1));
//		v.add(new FieldLabel(null, "Aggregate By"), new VerticalLayoutData(1, -1));
		v.add(verticalFunctionsLayout, new VerticalLayoutData(1, -1, new Margins(2, 1, 5,1)));
		
		ComboColumnDataFunctionPanel function = new ComboColumnDataFunctionPanel(1, store.getAll(), aggregationFunctions);
		verticalFunctionsLayout.add(function.getPanel());
		
		v.add(verticalFunctionsLayout, new VerticalLayoutData(1, -1, new Margins(2, 1, 5,1)));
		
		verticalFunctionsLayoutEnable(false);
		
		HBoxLayoutContainer hBox = new HBoxLayoutContainer();
		hBox.add(groupByButton, new BoxLayoutData(new Margins(2, 5, 2, 5)));
		v.add(hBox, new VerticalLayoutData(-1, -1, new Margins(10, 0, 10, 0)));
		
		
		add(v, new VerticalLayoutData(-1, -1, new Margins(0)));

	}
	
	protected void setEnableGroupByButton(boolean bool){
		groupByButton.setEnabled(bool);
	}

	protected void verticalFunctionsLayoutEnable(boolean bool){
		verticalFunctionsLayout.setEnabled(bool);
	}
	protected ArrayList<ColumnData> getSelectedItems() {
		return new ArrayList<ColumnData>(grid.getSelectionModel().getSelectedItems());

	}

	public void update(TRId trId, String columnName) {
		this.trId = trId;
		this.columnName = columnName;
		loader.load();
	}

	protected void loadData(ListLoadConfig loadConfig,final AsyncCallback<ListLoadResult<ColumnData>> callback) {TDGWTServiceAsync.INSTANCE.getColumns(trId,
				new AsyncCallback<ArrayList<ColumnData>>() {

					public void onFailure(Throwable caught) {
						if (caught instanceof TDGWTSessionExpiredException) {
							eventBus.fireEvent(new SessionExpiredEvent(
									SessionExpiredType.EXPIREDONSERVER));
						} else {
							Log.error("load columns failure:"
									+ caught.getLocalizedMessage());
							UtilsGXT3.alert("Error retrieving columns",
									"Error retrieving columns");
						}
						
						/************************TODO TEST CODE REMOVE THIS************************/
//						callback.onFailure(caught);
						
						
						addFakeColumn(callback);
					}

					public void onSuccess(ArrayList<ColumnData> result) {
//						Log.trace("loaded " + result.size() + " ColumnData");
//						callback.onSuccess(new ListLoadResultBean<ColumnData>(
//								result));

						
						/************************TODO TEST CODE REMOVE THIS************************/
						addFakeColumn(callback);
					}

				});

	}
	
	protected void addFakeColumn(AsyncCallback<ListLoadResult<ColumnData>> callback){
		
		/************************TODO TEST CODE REMOVE THIS************************/
		ArrayList<ColumnData> result = new ArrayList<ColumnData>();
		
		for (int i = 0; i <5; i++) {
			ColumnData cd = new ColumnData();
			cd.setColumnId("id"+"");
			cd.setId("id"+i);
			cd.setLabel("label"+i);
			cd.setTrId(new TRId("trid"+i, "tableId"+i));
			result.add(cd);
			
		}
		
		callback.onSuccess(new ListLoadResultBean<ColumnData>(result));
	}

	protected void onGroupByColumn() {
		
		/*
		ArrayList<ColumnData> columns = getSelectedItems();
		if (columns == null || columns.size() < 1) {
			UtilsGXT3.alert("Attention", "Attention no column selected!");
			return;
		} else {
			callStartGroupBy(columns);
		}
		*/
	}

	private void callStartGroupBy(ArrayList<ColumnData> columns) {


	}
	
	private void loadAggregateFunctions(){
		
		TdColumnOperationServiceAsync.Util.getInstance().getListAggregationFunctionIds(new AsyncCallback<List<TdAggregateFunction>>() {

			

			@Override
			public void onFailure(Throwable caught) {
				// TODO Auto-generated method stub
				
			}

			@Override
			public void onSuccess(List<TdAggregateFunction> result) {
				GWT.log("Aggregate functions loaded: "+result);
				aggregationFunctions = result;
			}
		});
	}

}
