/**
 * 
 */
package org.gcube.portlets.user.tdcolumnoperation.server.util;

import java.util.ArrayList;
import java.util.List;

import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.composite.aggregation.AggregationExpression;
import org.gcube.portlets.user.tdcolumnoperation.shared.TdAggregateFunction;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Jun 9, 2014
 * 
 */
public class ConvertForGwtModule {

	public static List<TdAggregateFunction> getAggregationFunctionIds() {

		List<Class<? extends Expression>> expressions = Expression.getExpressionsByCategory(AggregationExpression.class);
	
		
		List<TdAggregateFunction> aggFuncts = new ArrayList<TdAggregateFunction>(expressions.size());
		
		for (Class<? extends Expression> agg : expressions) 
			aggFuncts.add(new TdAggregateFunction(agg.getName(), agg.getSimpleName()));

		return aggFuncts;
	}
	

	public static void main(String[] args) {
		List<TdAggregateFunction> list = getAggregationFunctionIds();
		
		for (TdAggregateFunction tdAggregateFunction : list) {
			System.out.println(tdAggregateFunction);
		}
	}

}
