/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo.gridfs;

import com.mongodb.BasicDBObject;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import java.io.InputStream;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.document.mongo.gridfs.BaseCommand;

public class ReadBlobCommandGridFS
extends BaseCommand<Integer> {
    private final GridFS gridFS;
    private final String blobId;
    private final long blobOffset;
    private final byte[] buffer;
    private final int bufferOffset;
    private int length;

    public ReadBlobCommandGridFS(GridFS gridFS, String blobId, long blobOffset, byte[] buffer, int bufferOffset, int length) {
        this.gridFS = gridFS;
        this.blobId = blobId;
        this.blobOffset = blobOffset;
        this.buffer = buffer;
        this.bufferOffset = bufferOffset;
        this.length = length;
    }

    @Override
    public Integer execute() throws Exception {
        return this.fetchBlobFromMongo();
    }

    private int fetchBlobFromMongo() throws Exception {
        GridFSDBFile gridFile = this.gridFS.findOne(new BasicDBObject("md5", this.blobId));
        long fileLength = gridFile.getLength();
        long start = this.blobOffset;
        long end = this.blobOffset + (long)this.length;
        if (end > fileLength) {
            end = fileLength;
        }
        this.length = (int)(end - start);
        if (start < end) {
            InputStream is = gridFile.getInputStream();
            if (this.blobOffset > 0L) {
                IOUtils.skipFully(is, this.blobOffset);
            }
            IOUtils.readFully(is, this.buffer, this.bufferOffset, this.length);
            is.close();
            return this.length;
        }
        return -1;
    }
}

