/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.cloud;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.plugins.blob.CachingBlobStore;
import org.apache.jackrabbit.oak.spi.blob.AbstractBlobStore;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.io.Payload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudBlobStore
extends CachingBlobStore {
    private static final Logger LOG = LoggerFactory.getLogger(CloudBlobStore.class);
    private BlobStoreContext context;
    private String cloudContainer;
    private String accessKey;
    private String secretKey;
    private String cloudProvider;

    protected String getCloudContainer() {
        return this.cloudContainer;
    }

    public void setCloudContainer(String cloudContainer) {
        this.cloudContainer = cloudContainer;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getCloudProvider() {
        return this.cloudProvider;
    }

    public void setCloudProvider(String cloudProvider) {
        this.cloudProvider = cloudProvider;
    }

    public void init() throws Exception {
        try {
            this.context = (BlobStoreContext)ContextBuilder.newBuilder((String)this.cloudProvider).credentials(this.accessKey, this.secretKey).buildView(BlobStoreContext.class);
            this.context.getBlobStore().createContainerInLocation(null, this.cloudContainer);
            LOG.info("Using container : " + this.cloudContainer);
        }
        catch (Exception e) {
            LOG.error("Error creating CloudBlobStore : ", (Throwable)e);
            throw e;
        }
    }

    @Override
    protected void storeBlock(byte[] digest, int level, byte[] data) throws IOException {
        Preconditions.checkNotNull(this.context);
        String id = StringUtils.convertBytesToHex(digest);
        this.cache.put(id, data);
        BlobStore blobStore = this.context.getBlobStore();
        if (!blobStore.blobExists(this.cloudContainer, id)) {
            HashMap<String, String> metadata = Maps.newHashMap();
            metadata.put("level", String.valueOf(level));
            Blob blob = blobStore.blobBuilder(id).payload(data).userMetadata(metadata).build();
            String etag = blobStore.putBlob(this.cloudContainer, blob, PutOptions.Builder.multipart());
            LOG.debug("Blob " + id + " created with cloud tag : " + etag);
        } else {
            LOG.debug("Blob " + id + " already exists");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] readBlockFromBackend(AbstractBlobStore.BlockId blockId) throws Exception {
        Preconditions.checkNotNull(this.context);
        String id = StringUtils.convertBytesToHex(blockId.getDigest());
        byte[] data = (byte[])this.cache.get(id);
        if (data == null) {
            Blob cloudBlob = this.context.getBlobStore().getBlob(this.cloudContainer, id);
            if (cloudBlob == null) {
                String message = "Did not find block " + id;
                LOG.error(message);
                throw new IOException(message);
            }
            Payload payload = cloudBlob.getPayload();
            try {
                data = ByteStreams.toByteArray(payload.getInput());
                this.cache.put(id, data);
            }
            finally {
                payload.close();
            }
        }
        if (blockId.getPos() == 0L) {
            return data;
        }
        int len = (int)((long)data.length - blockId.getPos());
        if (len < 0) {
            return new byte[0];
        }
        byte[] d2 = new byte[len];
        System.arraycopy(data, (int)blockId.getPos(), d2, 0, len);
        return d2;
    }

    public void deleteBucket() {
        Preconditions.checkNotNull(this.context);
        if (this.context.getBlobStore().containerExists(this.cloudContainer)) {
            this.context.getBlobStore().deleteContainer(this.cloudContainer);
        }
        this.context.close();
    }

    @Override
    public void startMark() throws IOException {
    }

    @Override
    protected void mark(AbstractBlobStore.BlockId id) throws Exception {
    }

    @Override
    public int sweep() throws IOException {
        return 0;
    }

    @Override
    protected boolean isMarkEnabled() {
        return false;
    }

    @Override
    public Iterator<String> getAllChunkIds(long maxLastModifiedTime) throws Exception {
        Preconditions.checkNotNull(this.context);
        BlobStore blobStore = this.context.getBlobStore();
        return new CloudStoreIterator(blobStore, maxLastModifiedTime);
    }

    @Override
    public boolean deleteChunks(List<String> chunkIds, long maxLastModifiedTime) throws Exception {
        Preconditions.checkNotNull(this.context);
        for (String chunkId : chunkIds) {
            BlobStore blobStore = this.context.getBlobStore();
            BlobMetadata metadata = blobStore.blobMetadata(this.cloudContainer, chunkId);
            if (maxLastModifiedTime > 0L && metadata.getLastModified().getTime() > maxLastModifiedTime) continue;
            blobStore.removeBlob(this.cloudContainer, chunkId);
            return true;
        }
        return true;
    }

    class CloudStoreIterator
    implements Iterator<String> {
        private static final int BATCH = 1000;
        private BlobStore store;
        private long maxLastModifiedTime;
        private PageSet<? extends StorageMetadata> set;
        private ArrayDeque<String> queue;

        public CloudStoreIterator(BlobStore store, long maxLastModifiedTime) {
            this.store = store;
            this.maxLastModifiedTime = maxLastModifiedTime;
            this.queue = new ArrayDeque(1000);
        }

        @Override
        public boolean hasNext() {
            if (this.set == null || this.queue == null) {
                this.set = this.store.list(CloudBlobStore.this.cloudContainer, ListContainerOptions.Builder.maxResults((int)1000));
                this.loadElements(this.set);
            }
            if (!this.queue.isEmpty()) {
                return true;
            }
            if (this.set.getNextMarker() != null) {
                this.set = this.store.list(CloudBlobStore.this.cloudContainer, ListContainerOptions.Builder.maxResults((int)1000).afterMarker(this.set.getNextMarker()));
                this.loadElements(this.set);
                if (!this.queue.isEmpty()) {
                    return true;
                }
            }
            return false;
        }

        private void loadElements(PageSet<? extends StorageMetadata> set) {
            for (StorageMetadata metadata : set) {
                if (this.maxLastModifiedTime <= 0L || metadata.getLastModified().getTime() <= this.maxLastModifiedTime) {
                    this.queue.add(metadata.getName());
                    continue;
                }
                this.queue.add(metadata.getName());
            }
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements");
            }
            return this.queue.poll();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

