/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.aggregation;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.view.ViewQuery;
import com.couchbase.client.java.view.ViewResult;
import com.couchbase.client.java.view.ViewRow;
import java.io.File;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import org.gcube.accounting.aggregator.aggregation.AggregatorBuffer;
import org.gcube.accounting.aggregator.aggregation.DesignID;
import org.gcube.accounting.aggregator.status.AggregationState;
import org.gcube.accounting.aggregator.status.AggregationStatus;
import org.gcube.accounting.aggregator.utility.Constant;
import org.gcube.accounting.aggregator.utility.Utility;
import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.DSMapper;
import org.gcube.documentstore.records.RecordUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Aggregator {
    private static Logger logger = LoggerFactory.getLogger(Aggregator.class);
    private static final String TMP_SUFFIX = ".tmp";
    protected final AggregationStatus aggregationStatus;
    protected final Bucket bucket;
    protected final File originalRecordsbackupFile;
    protected final File aggregateRecordsBackupFile;
    protected Calendar startTime;

    public Aggregator(AggregationStatus aggregationStatus, Bucket bucket, File originalRecordsbackupFile, File aggregateRecordsBackupFile) {
        this.aggregationStatus = aggregationStatus;
        this.bucket = bucket;
        this.originalRecordsbackupFile = originalRecordsbackupFile;
        this.aggregateRecordsBackupFile = aggregateRecordsBackupFile;
    }

    public void aggregate() throws Exception {
        if (AggregationState.canContinue(this.aggregationStatus.getAggregationState(), AggregationState.STARTED)) {
            this.startTime = Utility.getUTCCalendarInstance();
            ViewResult viewResult = this.getViewResult();
            this.retrieveAndAggregate(viewResult);
        }
    }

    protected JsonArray generateKey(String key) {
        JsonArray arrayKey = JsonArray.create();
        for (String value : key.split("/")) {
            if (value.toString().isEmpty()) continue;
            arrayKey.add(Integer.parseInt(value));
        }
        return arrayKey;
    }

    protected ViewResult getViewResult() throws Exception {
        DateFormat dateFormat = this.aggregationStatus.getAggregationInfo().getAggregationType().getDateFormat();
        String dateStartKey = dateFormat.format(this.aggregationStatus.getAggregationInfo().getAggregationStartDate());
        String dateEndKey = dateFormat.format(this.aggregationStatus.getAggregationInfo().getAggregationEndDate());
        JsonArray startKey = this.generateKey(dateStartKey);
        JsonArray endKey = this.generateKey(dateEndKey);
        DesignID designid = DesignID.valueOf(this.bucket.name());
        String designDocId = designid.getDesignName();
        String viewName = designid.getViewName();
        ViewQuery query = ViewQuery.from((String)designDocId, (String)viewName);
        query.startKey(startKey);
        query.endKey(endKey);
        query.reduce(false);
        query.inclusiveEnd(false);
        logger.debug("View Query: designDocId:{} - viewName:{}, startKey:{} - endKey:{} ", new Object[]{designDocId, viewName, startKey, endKey});
        try {
            return this.bucket.query(query);
        }
        catch (Exception e) {
            logger.error("Exception error VIEW", (Object)e.getLocalizedMessage(), (Object)e);
            throw e;
        }
    }

    protected void retrieveAndAggregate(ViewResult viewResult) throws Exception {
        AggregatorBuffer aggregatorBuffer = new AggregatorBuffer();
        Calendar start = Utility.getUTCCalendarInstance();
        logger.debug("Elaboration of Records started at {}", (Object)Constant.DEFAULT_DATE_FORMAT.format(start.getTime()));
        this.originalRecordsbackupFile.delete();
        this.aggregateRecordsBackupFile.delete();
        int originalRecordsCounter = 0;
        for (ViewRow row : viewResult) {
            try {
                String record = ((JsonObject)row.document().content()).toString();
                record.replace("usageRecordType", "recordType");
                Utility.printLine(this.originalRecordsbackupFile, record);
                this.aggregateRow(aggregatorBuffer, record);
                if (++originalRecordsCounter % 1000 != 0) continue;
                int aggregatedRecordsNumber = aggregatorBuffer.getAggregatedRecords().size();
                int diff = originalRecordsCounter - aggregatedRecordsNumber;
                float percentage = 100 * diff / originalRecordsCounter;
                logger.info("{} At the moment, the elaborated original records are {}. The Aggregated records are {}. Difference {}. We are recovering {}% of Documents", new Object[]{this.aggregationStatus.getAggregationInfo(), originalRecordsCounter, aggregatedRecordsNumber, diff, Float.valueOf(percentage)});
            }
            catch (Exception e) {
                logger.error("Unable to elaborate {} {}", new Object[]{ViewRow.class.getSimpleName(), row, e});
                throw e;
            }
        }
        Calendar end = Utility.getUTCCalendarInstance();
        long duration = end.getTimeInMillis() - start.getTimeInMillis();
        String durationForHuman = Utility.getHumanReadableDuration(duration);
        logger.debug("{} Elaboration of Records terminated at {}. Duration {}", new Object[]{this.aggregationStatus.getAggregationInfo(), Constant.DEFAULT_DATE_FORMAT.format(end.getTime()), durationForHuman});
        File aggregateRecordsBackupFileTmp = new File(this.aggregateRecordsBackupFile.getParent(), this.aggregateRecordsBackupFile.getName() + TMP_SUFFIX);
        aggregateRecordsBackupFileTmp.delete();
        logger.debug("Going to save {} to file {}", (Object)AggregatedUsageRecord.class.getSimpleName(), (Object)this.aggregateRecordsBackupFile);
        List<AggregatedRecord<?, ?>> aggregatedRecords = aggregatorBuffer.getAggregatedRecords();
        for (AggregatedRecord<?, ?> aggregatedRecord : aggregatedRecords) {
            String marshalled = DSMapper.marshal(aggregatedRecord);
            JsonObject jsonObject = JsonObject.fromJson((String)marshalled);
            Utility.printLine(aggregateRecordsBackupFileTmp, jsonObject.toString());
        }
        aggregateRecordsBackupFileTmp.renameTo(this.aggregateRecordsBackupFile);
        this.aggregationStatus.setRecordNumbers(originalRecordsCounter, aggregatedRecords.size());
        this.aggregationStatus.setState(AggregationState.AGGREGATED, this.startTime, true);
    }

    protected void aggregateRow(AggregatorBuffer aggregatorBuffer, String json) throws Exception {
        AggregatedRecord record = (AggregatedRecord)RecordUtility.getRecord((String)json);
        record.setId(UUID.randomUUID().toString());
        aggregatorBuffer.aggregate(record);
    }

    protected JsonDocument getJsonDocument(ViewRow row) {
        String identifier = (String)((JsonObject)row.document().content()).get("id");
        JsonDocument jsonDocument = JsonDocument.create((String)identifier, (JsonObject)((JsonObject)row.document().content()));
        logger.trace("{}", (Object)jsonDocument.toString());
        return jsonDocument;
    }
}

