/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.status;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AggregationState {
    RESTARTED,
    STARTED,
    AGGREGATED,
    DELETED,
    ADDED,
    COMPLETED;

    private static Logger logger;

    public static boolean canContinue(AggregationState effective, AggregationState desired) throws Exception {
        if (effective == desired) {
            return true;
        }
        if (effective.ordinal() > desired.ordinal()) {
            logger.debug("{} is {}. The already reached value to continue is {}. The next step has been already done. It can be skipped.", new Object[]{AggregationState.class.getSimpleName(), effective.name(), desired.name()});
            return false;
        }
        String error = String.format("%s is %s which is lower than the required value to continue (%s). This is really strange and should not occur. Please contact the administrator.", AggregationState.class.getSimpleName(), effective.name(), desired.name());
        throw new Exception(error);
    }

    static {
        logger = LoggerFactory.getLogger(AggregationState.class);
    }
}

