/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.utility;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.gcube.accounting.aggregator.aggregation.AggregationType;
import org.gcube.accounting.aggregator.plugin.AccountingAggregatorPlugin;
import org.gcube.accounting.aggregator.utility.Constant;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utility {
    private static Logger logger = LoggerFactory.getLogger(Utility.class);
    public static TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    private static final String LOCALE_FORMAT_PATTERN = "Z";
    private static final DateFormat LOCALE_DATE_FORMAT = new SimpleDateFormat("Z");

    public static String getCurrentContext() throws Exception {
        return SecretManagerProvider.instance.get().getContext();
    }

    public static String getHumanReadableDuration(long duration) {
        return String.format("%d hours %02d minutes %02d seconds %03d milliseconds", duration / 3600000L, duration / 60000L % 60L, duration / 1000L % 60L, duration % 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printLine(File file, String line) throws Exception {
        File file2 = file;
        synchronized (file2) {
            try (FileWriter fw = new FileWriter(file, true);
                 BufferedWriter bw = new BufferedWriter(fw);
                 PrintWriter out = new PrintWriter(bw);){
                out.println(line);
                out.flush();
            }
        }
    }

    public static DateFormat getUTCDateFormat(String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setTimeZone(UTC_TIMEZONE);
        return dateFormat;
    }

    public static Calendar getUTCCalendarInstance() {
        return Calendar.getInstance(UTC_TIMEZONE);
    }

    public static Date getPersistTimeDate(String persistTimeString) throws ParseException {
        Date date = new Date();
        persistTimeString = AccountingAggregatorPlugin.AGGREGATION_START_DATE_DATE_FORMAT.format(date) + " " + persistTimeString + " " + LOCALE_DATE_FORMAT.format(date);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm Z");
        Date ret = dateFormat.parse(persistTimeString);
        return ret;
    }

    public static boolean isTimeElapsed(Calendar now, Date date) throws ParseException {
        try {
            boolean elapsed = now.getTime().after(date);
            logger.info("{} is {}elapsed.", (Object)AccountingAggregatorPlugin.LOCAL_TIME_DATE_FORMAT.format(date), (Object)(elapsed ? "" : "NOT "));
            return elapsed;
        }
        catch (Exception e) {
            logger.error("Unable to check if " + date.toString() + " is elapsed", (Throwable)e);
            throw e;
        }
    }

    public static Calendar getAggregationStartCalendar(int year, int month, int day) {
        Calendar aggregationStartCalendar = Utility.getUTCCalendarInstance();
        aggregationStartCalendar.set(1, year);
        aggregationStartCalendar.set(2, month);
        aggregationStartCalendar.set(5, day);
        aggregationStartCalendar.set(11, 0);
        aggregationStartCalendar.set(12, 0);
        aggregationStartCalendar.set(13, 0);
        aggregationStartCalendar.set(14, 0);
        logger.debug("{}", (Object)Constant.DEFAULT_DATE_FORMAT.format(aggregationStartCalendar.getTime()));
        return aggregationStartCalendar;
    }

    public static Date sanitizeDate(AggregationType aggregationType, Date date) {
        Calendar calendarToSanitize = Utility.getUTCCalendarInstance();
        calendarToSanitize.setTime(date);
        switch (aggregationType) {
            case DAILY: {
                break;
            }
            case MONTHLY: {
                calendarToSanitize.set(5, 1);
                break;
            }
            case YEARLY: {
                calendarToSanitize.set(5, 1);
                calendarToSanitize.set(2, 0);
                break;
            }
        }
        calendarToSanitize.set(11, 0);
        calendarToSanitize.set(12, 0);
        calendarToSanitize.set(13, 0);
        calendarToSanitize.set(14, 0);
        return calendarToSanitize.getTime();
    }

    public static Calendar getEndCalendarFromStartCalendar(AggregationType aggregationType, Calendar aggregationStartCalendar, int offset) {
        Calendar aggregationEndDate = Utility.getUTCCalendarInstance();
        aggregationEndDate.setTimeInMillis(aggregationStartCalendar.getTimeInMillis());
        aggregationEndDate.add(aggregationType.getCalendarField(), offset);
        return aggregationEndDate;
    }

    public static Date getEndDateFromStartDate(AggregationType aggregationType, Date aggregationStartDate, int offset) {
        Calendar aggregationEndDate = Utility.getUTCCalendarInstance();
        aggregationEndDate.setTimeInMillis(aggregationStartDate.getTime());
        aggregationEndDate.add(aggregationType.getCalendarField(), offset);
        return aggregationEndDate.getTime();
    }

    public static String getUsername() {
        return SecretManagerProvider.instance.get().getUser().getUsername();
    }

    public static File getMalformatedFile(File aggregateRecordsBackupFile) {
        return new File(aggregateRecordsBackupFile.getParent(), aggregateRecordsBackupFile.getName().replaceAll("aggregated", "malformed"));
    }
}

