/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.plugin;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.gcube.accounting.aggregator.RegexRulesAggregator;
import org.gcube.accounting.aggregator.aggregation.AggregationType;
import org.gcube.accounting.aggregator.elaboration.AggregatorManager;
import org.gcube.accounting.aggregator.elaboration.RecoveryManager;
import org.gcube.accounting.aggregator.utility.Utility;
import org.gcube.accounting.datamodel.aggregation.AggregatedServiceUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord;
import org.gcube.documentstore.persistence.PersistenceBackendFactory;
import org.gcube.documentstore.records.RecordUtility;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingAggregatorPlugin
extends Plugin {
    private static Logger logger = LoggerFactory.getLogger(AccountingAggregatorPlugin.class);
    public static final String NAME = "Accounting-Aggregator-Plugin";
    public static final String AGGREGATION_TYPE_INPUT_PARAMETER = "aggregationType";
    public static final String AGGREGATION_START_DATE_INPUT_PARAMETER = "aggregationStartDate";
    public static final String AGGREGATION_END_DATE_INPUT_PARAMETER = "aggregationEndDate";
    public static final String RESTART_FROM_LAST_AGGREGATION_DATE_INPUT_PARAMETER = "restartFromLastAggregationDate";
    public static final String AGGREGATION_START_DATE_DATE_FORMAT_PATTERN = "yyyy/MM/dd";
    public static final DateFormat AGGREGATION_START_DATE_DATE_FORMAT;
    private static final String AGGREGATION_START_END_DATE_UTC_DATE_FORMAT_PATTERN = "yyyy/MM/dd Z";
    private static final DateFormat AGGREGATION_START_END_DATE_UTC_DATE_FORMAT;
    private static final String UTC = "+0000";
    public static final String FORCE_EARLY_AGGREGATION = "forceEarlyAggregation";
    public static final String FORCE_RERUN = "forceRerun";
    public static final String FORCE_RESTART = "forceRestart";
    public static final String SKIP_AGGREGATION = "skipAggregation";
    public static final String ELABORATION_TYPE_INPUT_PARAMETER = "elaborationType";
    public static final String LOCAL_TIME_DATE_FORMAT_PATTERN = "HH:mm Z";
    public static final DateFormat LOCAL_TIME_DATE_FORMAT;
    public static final String RECORD_TYPE_INPUT_PARAMETER = "recordType";

    public AccountingAggregatorPlugin() {
        RegexRulesAggregator.getInstance();
    }

    public void launch(Map<String, Object> inputs) throws Exception {
        PersistenceBackendFactory.getPersistenceBackend((String)Utility.getCurrentContext());
        AggregationType aggregationType = null;
        Date aggregationStartDate = null;
        Date aggregationEndDate = null;
        boolean restartFromLastAggregationDate = false;
        ElaborationType elaborationType = ElaborationType.AGGREGATE;
        String recordType = null;
        Class usageRecordClass = null;
        boolean forceEarlyAggregation = false;
        boolean forceRerun = false;
        boolean forceRestart = false;
        boolean skipAggregation = false;
        if (inputs == null || inputs.isEmpty()) {
            throw new IllegalArgumentException("The can only be launched providing valid input parameters");
        }
        if (inputs.containsKey(ELABORATION_TYPE_INPUT_PARAMETER)) {
            elaborationType = ElaborationType.valueOf((String)inputs.get(ELABORATION_TYPE_INPUT_PARAMETER));
        }
        if (inputs.containsKey(AGGREGATION_START_DATE_INPUT_PARAMETER)) {
            Object aggregationStartDateString = (String)inputs.get(AGGREGATION_START_DATE_INPUT_PARAMETER);
            aggregationStartDateString = (String)aggregationStartDateString + " +0000";
            aggregationStartDate = AGGREGATION_START_END_DATE_UTC_DATE_FORMAT.parse((String)aggregationStartDateString);
        }
        if (inputs.containsKey(AGGREGATION_END_DATE_INPUT_PARAMETER)) {
            Object aggregationEndDateString = (String)inputs.get(AGGREGATION_END_DATE_INPUT_PARAMETER);
            aggregationEndDateString = (String)aggregationEndDateString + " +0000";
            aggregationEndDate = AGGREGATION_START_END_DATE_UTC_DATE_FORMAT.parse((String)aggregationEndDateString);
        }
        if (inputs.containsKey(FORCE_RESTART)) {
            forceRestart = (Boolean)inputs.get(FORCE_RESTART);
        }
        if (inputs.containsKey(AGGREGATION_TYPE_INPUT_PARAMETER)) {
            aggregationType = AggregationType.valueOf((String)inputs.get(AGGREGATION_TYPE_INPUT_PARAMETER));
        }
        if (inputs.containsKey(RECORD_TYPE_INPUT_PARAMETER)) {
            recordType = (String)inputs.get(RECORD_TYPE_INPUT_PARAMETER);
            usageRecordClass = RecordUtility.getRecordClass((String)recordType);
            logger.debug("Requested record type is {} which is implemented by {}", (Object)recordType, (Object)usageRecordClass);
        }
        switch (elaborationType) {
            case AGGREGATE: {
                if (!inputs.containsKey(AGGREGATION_TYPE_INPUT_PARAMETER)) {
                    throw new IllegalArgumentException("Please set required parameter 'aggregationType'");
                }
                if (inputs.containsKey(RESTART_FROM_LAST_AGGREGATION_DATE_INPUT_PARAMETER)) {
                    restartFromLastAggregationDate = (Boolean)inputs.get(RESTART_FROM_LAST_AGGREGATION_DATE_INPUT_PARAMETER);
                }
                if (inputs.containsKey(FORCE_EARLY_AGGREGATION)) {
                    forceEarlyAggregation = (Boolean)inputs.get(FORCE_EARLY_AGGREGATION);
                }
                if (inputs.containsKey(FORCE_RERUN)) {
                    forceRerun = (Boolean)inputs.get(FORCE_RERUN);
                }
                if (!restartFromLastAggregationDate && aggregationStartDate == null) {
                    throw new IllegalArgumentException("Aggregation Start Date cannot be found. Please provide it as parameter or set 'restartFromLastAggregationDate' input parameter to 'true'.");
                }
                if (inputs.containsKey(SKIP_AGGREGATION)) {
                    skipAggregation = (Boolean)inputs.get(SKIP_AGGREGATION);
                }
                AggregatorManager aggregatorManager = new AggregatorManager(aggregationType, restartFromLastAggregationDate, aggregationStartDate, aggregationEndDate);
                aggregatorManager.setForceEarlyAggregation(forceEarlyAggregation);
                aggregatorManager.setForceRerun(forceRerun);
                aggregatorManager.setForceRestart(forceRestart);
                aggregatorManager.setSkipAggregation(skipAggregation);
                aggregatorManager.elaborate(recordType);
                break;
            }
            case RECOVERY: {
                RecoveryManager recoveryManager = new RecoveryManager(aggregationStartDate, aggregationEndDate);
                recoveryManager.setForceRestart(forceRestart);
                recoveryManager.setRecordType(recordType);
                recoveryManager.setAggregationType(aggregationType);
                recoveryManager.recovery();
                break;
            }
            default: {
                throw new IllegalArgumentException("No ElaborationType provided. You should not be here. Please Contact the administrator");
            }
        }
    }

    protected void onStop() throws Exception {
        logger.trace("Stopping execution of {}, UUID : {}", (Object)this.getName(), (Object)this.uuid);
        Thread.currentThread().interrupt();
    }

    static {
        RecordUtility.addRecordPackage((Package)ServiceUsageRecord.class.getPackage());
        RecordUtility.addRecordPackage((Package)AggregatedServiceUsageRecord.class.getPackage());
        AGGREGATION_START_DATE_DATE_FORMAT = Utility.getUTCDateFormat(AGGREGATION_START_DATE_DATE_FORMAT_PATTERN);
        AGGREGATION_START_END_DATE_UTC_DATE_FORMAT = Utility.getUTCDateFormat(AGGREGATION_START_END_DATE_UTC_DATE_FORMAT_PATTERN);
        LOCAL_TIME_DATE_FORMAT = new SimpleDateFormat(LOCAL_TIME_DATE_FORMAT_PATTERN);
    }

    public static enum ElaborationType {
        AGGREGATE,
        RECOVERY;

    }
}

