/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonObject;
import java.util.Map;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public class SearchControl {
    private final long timeout;
    private final Consistency consistency;

    protected SearchControl(Builder builder) {
        this.timeout = builder.timeout;
        this.consistency = builder.consistency;
    }

    public JsonObject json() {
        JsonObject json = JsonObject.create();
        json.put("timeout", this.timeout);
        if (this.consistency != null) {
            json.put("consistency", this.consistency.json());
        }
        return json;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Consistency {
        private static final String LEVEL = "at_plus";
        private final String level;
        private final Map<String, Map<String, Integer>> vectors;

        protected Consistency(Builder builder) {
            this.level = builder.level;
            this.vectors = builder.vectors;
        }

        public JsonObject json() {
            JsonObject json = JsonObject.create();
            json.put("level", this.level);
            if (this.vectors != null) {
                JsonObject vectorsJson = JsonObject.create();
                for (Map.Entry<String, Map<String, Integer>> entry : this.vectors.entrySet()) {
                    vectorsJson.put(entry.getKey(), JsonObject.from(entry.getValue()));
                }
                json.put("vectors", vectorsJson);
            }
            return json;
        }

        public Builder builder() {
            return new Builder();
        }

        public static class Builder {
            public String level = "at_plus";
            public Map<String, Map<String, Integer>> vectors;

            protected Builder() {
            }

            public Consistency build() {
                return new Consistency(this);
            }

            public Builder level(String level) {
                this.level = level;
                return this;
            }

            public Builder vectors(Map<String, Map<String, Integer>> vectors) {
                this.vectors = vectors;
                return this;
            }
        }
    }

    public static class Builder {
        public long timeout;
        public Consistency consistency;

        protected Builder() {
        }

        public SearchControl build() {
            return new SearchControl(this);
        }

        public Builder timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder consistency(Consistency consistency) {
            this.consistency = consistency;
            return this;
        }
    }
}

