/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.query;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.query.SearchQuery;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public class RegexpQuery
extends SearchQuery {
    private final String regexp;
    private final String field;

    protected RegexpQuery(Builder builder) {
        super(builder);
        this.regexp = builder.regexp;
        this.field = builder.field;
    }

    public static Builder on(String index) {
        return new Builder(index);
    }

    public String regexp() {
        return this.regexp;
    }

    public String field() {
        return this.field;
    }

    @Override
    public JsonObject queryJson() {
        return JsonObject.create().put("regexp", this.regexp).put("field", this.field);
    }

    public static class Builder
    extends SearchQuery.Builder {
        private String regexp;
        private String field;

        protected Builder(String index) {
            super(index);
        }

        @Override
        public RegexpQuery build() {
            return new RegexpQuery(this);
        }

        public Builder regexp(String regexp) {
            this.regexp = regexp;
            return this;
        }

        public Builder field(String field) {
            this.field = field;
            return this;
        }
    }
}

