/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transcoder.subdoc;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.subdoc.MultiValue;
import com.couchbase.client.java.transcoder.subdoc.FragmentTranscoder;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public abstract class AbstractFragmentTranscoder
implements FragmentTranscoder {
    @Override
    public <T> T decode(ByteBuf encoded, Class<? extends T> clazz) throws TranscodingException {
        return this.decodeWithMessage(encoded, clazz, null);
    }

    @Override
    public <T> ByteBuf encode(T value) throws TranscodingException {
        return this.encodeWithMessage(value, null);
    }

    @Override
    public <T> ByteBuf encodeWithMessage(T value, String transcodingErrorMessage) throws TranscodingException {
        if (value instanceof MultiValue) {
            return this.doEncodeMulti((MultiValue)value, transcodingErrorMessage);
        }
        return this.doEncodeSingle(value, transcodingErrorMessage);
    }

    protected abstract <T> ByteBuf doEncodeSingle(T var1, String var2) throws TranscodingException;

    protected abstract ByteBuf doEncodeMulti(MultiValue<?> var1, String var2) throws TranscodingException;
}

