/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.analytics.persistence.couchbase;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.bucket.BucketManager;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import com.couchbase.client.java.query.N1qlQueryResult;
import com.couchbase.client.java.query.N1qlQueryRow;
import com.couchbase.client.java.query.Select;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.Sort;
import com.couchbase.client.java.query.dsl.path.LimitPath;
import com.couchbase.client.java.view.OnError;
import com.couchbase.client.java.view.View;
import com.couchbase.client.java.view.ViewQuery;
import com.couchbase.client.java.view.ViewResult;
import com.couchbase.client.java.view.ViewRow;
import java.security.KeyException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.NumberedFilter;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.analytics.UsageServiceValue;
import org.gcube.accounting.analytics.UsageStorageValue;
import org.gcube.accounting.analytics.UsageValue;
import org.gcube.accounting.analytics.exception.DuplicatedKeyFilterException;
import org.gcube.accounting.analytics.exception.ValueException;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQueryConfiguration;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQuery;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedServiceUsageRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedStorageStatusRecord;
import org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.RecordUtility;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingPersistenceQueryCouchBase
implements AccountingPersistenceBackendQuery {
    private static final Logger logger = LoggerFactory.getLogger(AccountingPersistenceQueryCouchBase.class);
    public static final String URL_PROPERTY_KEY = "URL";
    public static final String PASSWORD_PROPERTY_KEY = "password";
    protected static final CouchbaseEnvironment ENV;
    public static final long MAX_REQUEST_LIFE_TIME;
    public static final long KEEP_ALIVE_INTERVAL;
    public static final long AUTO_RELEASE_AFTER;
    public static final long VIEW_TIMEOUT_BUCKET;
    public static final long CONNECTION_TIMEOUT_BUCKET;
    public static final long CONNECTION_TIMEOUT;
    protected AccountingPersistenceBackendQueryConfiguration configuration;
    protected Cluster cluster;
    protected Map<String, Bucket> connectionMap;
    public static final String DESIGN_DOC_ID_LIST_USAGE = "ListUsage";
    protected static final String MAP_REDUCE__DESIGN = "";
    protected static final String MAP_REDUCE_ALL = "all";
    protected static final String KEYS_SEPARATOR = "__";
    protected static final String DESIGN_DOC_ID = "top_";
    protected static final String AGGREGATED_PREFIX = "Aggregated";

    public boolean isConnectionActive() throws Exception {
        return !this.connectionMap.values().iterator().next().isClosed();
    }

    public void prepareConnection(AccountingPersistenceBackendQueryConfiguration configuration) throws Exception {
        String url = configuration.getProperty(URL_PROPERTY_KEY);
        this.cluster = CouchbaseCluster.create((CouchbaseEnvironment)ENV, (String[])new String[]{url});
        this.configuration = configuration;
        this.connectionMap = new HashMap<String, Bucket>();
    }

    protected Bucket getBucket(Class<? extends UsageRecord> clz) throws Exception {
        UsageRecord instance = clz.newInstance();
        String recordType = instance.getRecordType();
        return this.getBucket(recordType);
    }

    protected Bucket getBucket(String recordType) throws Exception {
        Bucket bucket;
        if (recordType.startsWith(AGGREGATED_PREFIX)) {
            recordType = recordType.replace(AGGREGATED_PREFIX, MAP_REDUCE__DESIGN);
        }
        if ((bucket = this.connectionMap.get(recordType)) == null) {
            logger.debug("Trying to get the Bucket for {}", (Object)recordType);
            String bucketName = this.configuration.getProperty(recordType);
            logger.debug("Bucket for {} is {}. Going to open it.", (Object)recordType, (Object)bucketName);
            bucket = this.cluster.openBucket(bucketName, this.configuration.getProperty(PASSWORD_PROPERTY_KEY));
            this.connectionMap.put(recordType, bucket);
        }
        return bucket;
    }

    public void close() throws Exception {
        this.cluster.disconnect();
    }

    protected Calendar getCalendar(JSONObject obj, TemporalConstraint.AggregationMode aggregationMode) throws NumberFormatException, JSONException {
        long millis;
        if (obj.has("startTime")) {
            millis = new Long(obj.getString("startTime"));
            logger.trace("The result {} was from an aggregated record. Using {}", (Object)obj.toString(), (Object)"startTime");
        } else {
            millis = new Long(obj.getString("creationTime"));
            logger.trace("The result {} was from single record. Using {}", (Object)obj.toString(), (Object)"creationTime");
        }
        Calendar calendar = TemporalConstraint.getAlignedCalendar((long)millis, (TemporalConstraint.AggregationMode)aggregationMode);
        logger.trace("{} has been aligned to {}", (Object)millis, (Object)calendar.getTimeInMillis());
        return calendar;
    }

    protected Calendar getCalendarFromArray(JsonArray array) throws JSONException {
        boolean startFound = false;
        Calendar calendar = Calendar.getInstance(TemporalConstraint.DEFAULT_TIME_ZONE);
        int count = 0;
        TemporalConstraint.CalendarEnum[] calendarValues = TemporalConstraint.CalendarEnum.values();
        for (int i = 0; i < array.size(); ++i) {
            try {
                int value = array.getInt(i);
                int calendarValue = calendarValues[count].getCalendarValue();
                if (calendarValue == 2) {
                    --value;
                }
                calendar.set(calendarValue, value);
                ++count;
                startFound = true;
                continue;
            }
            catch (Exception e) {
                if (startFound) break;
            }
        }
        for (int j = count; j < calendarValues.length; ++j) {
            if (calendarValues[j].getCalendarValue() == 5) {
                calendar.set(calendarValues[j].getCalendarValue(), 1);
                continue;
            }
            calendar.set(calendarValues[j].getCalendarValue(), 0);
        }
        return calendar;
    }

    protected JsonArray getRangeKey(long time, TemporalConstraint.AggregationMode aggregationMode, boolean wildCard, boolean endKey) throws JSONException {
        JsonArray array = JsonArray.create();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        TemporalConstraint.CalendarEnum[] values = TemporalConstraint.CalendarEnum.values();
        if (endKey) {
            calendar.add(values[aggregationMode.ordinal()].getCalendarValue(), 1);
        }
        for (int i = 0; i <= aggregationMode.ordinal(); ++i) {
            int value = calendar.get(values[i].getCalendarValue());
            if (values[i].getCalendarValue() == 2) {
                ++value;
            }
            array.add(value);
        }
        if (wildCard) {
            array.add("{}");
        }
        return array;
    }

    @Deprecated
    protected String getDesignDocId(Class<? extends AggregatedRecord<?, ?>> recordClass) throws InstantiationException, IllegalAccessException {
        return String.format("%s%s", MAP_REDUCE__DESIGN, recordClass.newInstance().getRecordType());
    }

    protected String getDesignDocIdSpecific(Class<? extends AggregatedRecord<?, ?>> recordClass, Collection<String> keys) throws InstantiationException, IllegalAccessException {
        String specific = MAP_REDUCE_ALL;
        if (!keys.isEmpty()) {
            specific = keys.iterator().next();
        }
        String getDesigndocIdSpecific = specific;
        return getDesigndocIdSpecific;
    }

    public static String getMapReduceFunctionName(Collection<String> collection) {
        String reduceFunction = MAP_REDUCE_ALL;
        if (!collection.isEmpty()) {
            reduceFunction = null;
            for (String property : collection) {
                if (reduceFunction == null) {
                    reduceFunction = property;
                    continue;
                }
                reduceFunction = reduceFunction + KEYS_SEPARATOR + property;
            }
        }
        return reduceFunction;
    }

    public static String getMapReduceFunctionNameTopMap(String top, Collection<String> collection) {
        logger.debug("top:{}", (Object)top);
        logger.debug("collection:{}", (Object)collection.toString());
        String reduceFunction = MAP_REDUCE_ALL;
        if (!collection.isEmpty()) {
            reduceFunction = top;
            for (String property : collection) {
                if (property.equals(top)) continue;
                if (reduceFunction == null) {
                    reduceFunction = property;
                    continue;
                }
                reduceFunction = reduceFunction + KEYS_SEPARATOR + property;
            }
        }
        return reduceFunction;
    }

    public static String getDesignDocIdName(Collection<String> collection) {
        String reduceFunction = MAP_REDUCE_ALL;
        if (!collection.isEmpty()) {
            String property;
            reduceFunction = null;
            reduceFunction = property = collection.iterator().next();
        }
        return reduceFunction;
    }

    protected SortedMap<Calendar, Info> mapReduceQuery(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String context, Boolean valueEmpty, Boolean noScope) throws Exception {
        ViewResult viewResult;
        int scopeDateGroupLevel;
        String currentScope = AccountingPersistenceBackendQuery.getScopeToQuery();
        if (context != null) {
            currentScope = context;
        }
        JsonArray startKey = JsonArray.create();
        JsonArray endKey = JsonArray.create();
        if (!noScope.booleanValue()) {
            startKey.add(currentScope);
            endKey.add(currentScope);
        }
        TemporalConstraint.AggregationMode aggregationMode = temporalConstraint.getAggregationMode();
        JsonArray temporalStartKey = this.getRangeKey(temporalConstraint.getStartTime(), aggregationMode, false, false);
        JsonArray temporalEndKey = this.getRangeKey(temporalConstraint.getEndTime(), aggregationMode, false, false);
        SortedSet recordKeysSet = AccountingPersistenceQuery.getQuerableKeys(clz);
        TreeSet<String> keys = new TreeSet<String>();
        if (filters != null && filters.size() != 0) {
            Collections.sort(filters, new Comparator<Filter>(){

                @Override
                public int compare(Filter filter1, Filter filter2) {
                    int result = filter1.getKey().compareTo(filter2.getKey());
                    return result;
                }
            });
            for (Filter filter : filters) {
                String filterKey = filter.getKey();
                String filterValue = filter.getValue();
                if (filterKey != null && filterKey.compareTo(MAP_REDUCE__DESIGN) != 0 && recordKeysSet.contains(filterKey)) {
                    if (filterValue != null && filterValue.compareTo(MAP_REDUCE__DESIGN) != 0) {
                        if (keys.contains(filterKey)) {
                            throw new DuplicatedKeyFilterException("Only one value per Filter key is allowed");
                        }
                        startKey.add(filterValue);
                        endKey.add(filterValue);
                        keys.add(filterKey);
                        continue;
                    }
                    throw new KeyException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
                }
                throw new ValueException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
            }
        }
        int groupLevel = scopeDateGroupLevel = aggregationMode.ordinal() + 1 + 1;
        if (filters != null) {
            groupLevel += keys.size();
        }
        String designDocId = this.getDesignDocIdSpecific(clz, keys);
        if (noScope.booleanValue()) {
            designDocId = "noContext";
            --groupLevel;
        }
        for (Object temporal : temporalStartKey.toList()) {
            if (temporal.toString().isEmpty()) continue;
            startKey.add(temporal);
        }
        int count = 1;
        for (Object temporal : temporalEndKey.toList()) {
            if (!temporal.toString().isEmpty()) {
                if (count == temporalEndKey.size()) {
                    temporal = (Integer)temporal + 1;
                }
                endKey.add(temporal);
            }
            ++count;
        }
        String viewName = AccountingPersistenceQueryCouchBase.getMapReduceFunctionName(keys);
        ViewQuery query = ViewQuery.from((String)designDocId, (String)viewName);
        query.inclusiveEnd();
        query.groupLevel(groupLevel);
        query.startKey(startKey);
        query.endKey(endKey);
        query.descending(false);
        logger.trace("Bucket :{}, Design Doc ID : {}, View Name : {}, Group Level : {}, Start Key : {}, End Key : {},temporalStartKey :{}, temporalEndKey :{}", new Object[]{clz.getSimpleName(), designDocId, viewName, groupLevel, startKey, endKey, temporalStartKey.toString(), temporalEndKey.toString()});
        TreeMap<Calendar, Info> infos = new TreeMap<Calendar, Info>();
        Bucket bucket = this.getBucket(clz);
        try {
            viewResult = bucket.query(query);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
            throw e;
        }
        for (ViewRow row : viewResult) {
            JsonArray array = (JsonArray)row.key();
            Calendar calendar = this.getCalendarFromArray(array);
            JsonObject value = (JsonObject)row.value();
            JSONObject obj = new JSONObject(value.toString());
            Info info = new Info(calendar, obj);
            infos.put(calendar, info);
        }
        logger.trace("valueEmpty not permitted:{}", (Object)valueEmpty);
        if (valueEmpty.booleanValue() && infos.isEmpty()) {
            logger.trace("infos is empity");
            query = ViewQuery.from((String)designDocId, (String)viewName);
            query.groupLevel(groupLevel);
            query.descending(false);
            try {
                viewResult = bucket.query(query);
            }
            catch (Exception e) {
                logger.warn("not execute query", (Object)e.getLocalizedMessage());
            }
            try {
                if (viewResult.totalRows() != 0) {
                    ViewRow row = (ViewRow)viewResult.allRows().get(0);
                    JsonArray array = this.getRangeKey(temporalConstraint.getStartTime(), aggregationMode, false, false);
                    Calendar calendar = this.getCalendarFromArray(array);
                    JsonObject value = (JsonObject)row.value();
                    JSONObject objJson = new JSONObject(value.toString());
                    JSONObject objJsontemplate = new JSONObject();
                    Iterator iterateJson = objJson.keys();
                    while (iterateJson.hasNext()) {
                        String key = (String)iterateJson.next();
                        objJsontemplate.put(key, 0);
                    }
                    Info info = new Info(calendar, objJsontemplate);
                    infos.put(calendar, info);
                }
            }
            catch (Exception e) {
                logger.warn("error :{}", (Object)e.getLocalizedMessage());
            }
        }
        logger.trace("infos:{}", (Object)((Object)infos).toString());
        return infos;
    }

    public SortedMap<Calendar, Info> getTimeSeries(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters) throws Exception {
        SortedMap<Calendar, Info> map = this.mapReduceQuery(clz, temporalConstraint, filters, null, true, false);
        return map;
    }

    public SortedMap<Calendar, Info> getNoContextTimeSeries(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters) throws Exception {
        SortedMap<Calendar, Info> map = this.mapReduceQuery(clz, temporalConstraint, filters, null, true, true);
        return map;
    }

    public SortedMap<NumberedFilter, SortedMap<Calendar, Info>> getTopValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String topKey, String orderingProperty) throws Exception {
        Comparator<NumberedFilter> comparator = new Comparator<NumberedFilter>(){

            @Override
            public int compare(NumberedFilter o1, NumberedFilter o2) {
                int result = -o1.compareTo(o2);
                if (result == 0) {
                    result = o1.compareTo((Filter)o2);
                }
                return result;
            }
        };
        TreeMap<NumberedFilter, SortedMap<Calendar, Info>> ret = new TreeMap<NumberedFilter, SortedMap<Calendar, Info>>(comparator);
        SortedSet<NumberedFilter> top = null;
        if (this.usingNextPossibleValuesWithMap(clz, topKey, filters)) {
            logger.trace("getNextPossibleValues using map");
            top = this.getNextPossibleValuesWithMap(clz, temporalConstraint, filters, topKey, orderingProperty);
        } else {
            logger.trace("getNextPossibleValues using query");
            top = this.getNextPossibleValues(clz, temporalConstraint, filters, topKey, orderingProperty);
        }
        logger.trace("getNextPossibleValues:{}", (Object)top.toString());
        for (NumberedFilter nf : top) {
            filters.add((Filter)nf);
            SortedMap<Calendar, Info> map = this.mapReduceQuery(clz, temporalConstraint, filters, null, true, false);
            ret.put(nf, map);
            filters.remove(nf);
        }
        return ret;
    }

    protected boolean usingNextPossibleValuesWithMap(Class<? extends AggregatedRecord<?, ?>> clz, String topKey, List<Filter> filters) throws Exception {
        logger.debug("usingNextPossibleValuesWithMap init");
        TreeSet<String> keys = new TreeSet<String>();
        try {
            SortedSet recordKeysSet = AccountingPersistenceQuery.getQuerableKeys(clz);
            keys.add(topKey);
            if (filters != null && filters.size() != 0) {
                Collections.sort(filters, new Comparator<Filter>(){

                    @Override
                    public int compare(Filter filter1, Filter filter2) {
                        int result = filter1.getKey().compareTo(filter2.getKey());
                        return result;
                    }
                });
                for (Filter filter : filters) {
                    String filterKey = filter.getKey();
                    String filterValue = filter.getValue();
                    if (filterKey != null && filterKey.compareTo(MAP_REDUCE__DESIGN) != 0 && recordKeysSet.contains(filterKey)) {
                        if (filterValue != null && filterValue.compareTo(MAP_REDUCE__DESIGN) != 0) {
                            if (keys.contains(filterKey)) {
                                throw new DuplicatedKeyFilterException("Only one value per Filter key is allowed");
                            }
                            keys.add(filterKey);
                            continue;
                        }
                        throw new KeyException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
                    }
                    throw new ValueException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
                }
            }
        }
        catch (Exception e1) {
            logger.warn("usingNextPossibleValuesWithMap -exception with filter:{}", (Object)filters.toString());
            return false;
        }
        logger.debug("usingNextPossibleValuesWithMap complete key and name");
        String viewName = AccountingPersistenceQueryCouchBase.getMapReduceFunctionNameTopMap(topKey, keys);
        String designDocId = DESIGN_DOC_ID + topKey;
        Bucket bucket = this.getBucket(clz);
        BucketManager bucketManager = bucket.bucketManager();
        if (bucketManager.getDesignDocument(designDocId) != null) {
            logger.debug("usingNextPossibleValuesWithMap designDocId exist:{}-and viewname:{}-", (Object)designDocId, (Object)viewName);
            for (View view : bucketManager.getDesignDocument(designDocId).views()) {
                logger.debug("found:{}- ", (Object)view.name());
                if (!view.name().equals(viewName)) continue;
                logger.debug("usingNextPossibleValuesWithMap viewname exist");
                return true;
            }
        } else {
            logger.debug("usingNextPossibleValuesWithQuery");
            return false;
        }
        return false;
    }

    public SortedSet<NumberedFilter> getNextPossibleValuesWithMap(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String key, String orderingProperty) throws Exception {
        ViewResult viewResult;
        logger.debug("getNextPossibleValuesWithMap init");
        String currentScope = AccountingPersistenceBackendQuery.getScopeToQuery();
        if (orderingProperty == null) {
            orderingProperty = AccountingPersistenceQuery.getDefaultOrderingProperties(clz);
        }
        JsonArray startKey = JsonArray.create();
        startKey.add(currentScope);
        JsonArray endKey = JsonArray.create();
        endKey.add(currentScope);
        TemporalConstraint.AggregationMode aggregationMode = temporalConstraint.getAggregationMode();
        JsonArray temporalStartKey = this.getRangeKey(temporalConstraint.getStartTime(), aggregationMode, false, false);
        JsonArray temporalEndKey = this.getRangeKey(temporalConstraint.getEndTime(), aggregationMode, false, false);
        SortedSet recordKeysSet = AccountingPersistenceQuery.getQuerableKeys(clz);
        TreeSet<String> keys = new TreeSet<String>();
        keys.add(key);
        ArrayList<Expression> selectExpressions = new ArrayList<Expression>();
        selectExpressions.add(Expression.x((String)("SUM(CASE WHEN " + this.getSpecializedProperty(clz, orderingProperty) + " IS NOT NULL THEN " + this.getSpecializedProperty(clz, orderingProperty) + " ELSE 1 END )")).as(orderingProperty));
        selectExpressions.add(Expression.x((String)("(CASE WHEN " + this.getSpecializedProperty(clz, key) + " IS NOT NULL THEN " + this.getSpecializedProperty(clz, key) + " ELSE 'UNKNOWN' END )")).as(key));
        Expression whereExpression = Expression.x((String)this.getSpecializedProperty(clz, "scope")).eq(Expression.s((String[])new String[]{currentScope}));
        long startTime = temporalConstraint.getAlignedStartTime().getTimeInMillis();
        whereExpression = whereExpression.and(Expression.x((String)this.getSpecializedProperty(clz, "startTime")).gt(startTime));
        long endTime = temporalConstraint.getEndTime();
        whereExpression = whereExpression.and(Expression.x((String)this.getSpecializedProperty(clz, "endTime")).lt(endTime));
        Expression[] selectExpressionArray = new Expression[selectExpressions.size()];
        selectExpressions.toArray(selectExpressionArray);
        Sort sort = Sort.desc((String)orderingProperty);
        Bucket bucket = this.getBucket(clz);
        LimitPath path = Select.select((Expression[])selectExpressionArray).from(bucket.name()).where(whereExpression).groupBy(new String[]{key}).orderBy(new Sort[]{sort});
        if (filters != null && filters.size() != 0) {
            Collections.sort(filters, new Comparator<Filter>(){

                @Override
                public int compare(Filter filter1, Filter filter2) {
                    int result = filter1.getKey().compareTo(filter2.getKey());
                    return result;
                }
            });
            for (Filter filter : filters) {
                String filterKey = filter.getKey();
                String filterValue = filter.getValue();
                if (filterKey != null && filterKey.compareTo(MAP_REDUCE__DESIGN) != 0 && recordKeysSet.contains(filterKey)) {
                    if (filterValue != null && filterValue.compareTo(MAP_REDUCE__DESIGN) != 0) {
                        if (keys.contains(filterKey)) {
                            throw new DuplicatedKeyFilterException("Only one value per Filter key is allowed");
                        }
                        startKey.add(filterValue);
                        endKey.add(filterValue);
                        whereExpression = whereExpression.and(Expression.x((String)this.getSpecializedProperty(clz, filterKey)).eq(Expression.s((String[])new String[]{filterValue})));
                        keys.add(filterKey);
                        continue;
                    }
                    throw new KeyException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
                }
                throw new ValueException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
            }
        }
        logger.debug("Alternative Query for top:" + path.toString());
        int groupLevel = 1;
        for (Object temporal : temporalStartKey.toList()) {
            if (temporal.toString().isEmpty()) continue;
            startKey.add(temporal);
        }
        int count = 1;
        for (Object temporal : temporalEndKey.toList()) {
            if (!temporal.toString().isEmpty()) {
                if (count == temporalEndKey.size()) {
                    temporal = (Integer)temporal + 1;
                }
                endKey.add(temporal);
            }
            ++count;
        }
        String viewName = AccountingPersistenceQueryCouchBase.getMapReduceFunctionNameTopMap(key, keys);
        String designDocId = DESIGN_DOC_ID + key;
        logger.trace("keys:{}", (Object)((Object)keys).toString());
        ViewQuery query = ViewQuery.from((String)designDocId, (String)viewName);
        query.inclusiveEnd();
        query.groupLevel(groupLevel);
        query.startKey(startKey);
        query.endKey(endKey);
        query.descending(false);
        logger.trace("Bucket :{}, Design Doc ID : {}, View Name : {}, Group Level : {}, Start Key : {}, End Key : {},temporalStartKey :{}, temporalEndKey :{}", new Object[]{clz.getSimpleName(), designDocId, viewName, groupLevel, startKey, endKey, temporalStartKey.toString(), temporalEndKey.toString()});
        Comparator<NumberedFilter> comparator = new Comparator<NumberedFilter>(){

            @Override
            public int compare(NumberedFilter o1, NumberedFilter o2) {
                int compareResult = -o1.compareTo(o2);
                if (compareResult == 0) {
                    compareResult = 1;
                }
                return compareResult;
            }
        };
        TreeSet<NumberedFilter> ret = new TreeSet<NumberedFilter>(comparator);
        try {
            viewResult = bucket.query(query);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
            throw e;
        }
        ViewRow row = (ViewRow)viewResult.allRows().get(0);
        JsonObject value = (JsonObject)row.value();
        JSONObject objectValueTop = new JSONObject(value.toString());
        Iterator iterateJosn = objectValueTop.keys();
        while (iterateJosn.hasNext()) {
            String keyTop = (String)iterateJosn.next();
            Number n = (Number)objectValueTop.get(keyTop);
            if (n == null) {
                n = 0;
            }
            NumberedFilter numberedFilter = new NumberedFilter(key, keyTop, n, orderingProperty);
            ret.add(numberedFilter);
        }
        return ret;
    }

    public SortedSet<NumberedFilter> getNextPossibleValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String key, String orderingProperty) throws Exception {
        String currentScope = AccountingPersistenceBackendQuery.getScopeToQuery();
        if (orderingProperty == null) {
            orderingProperty = AccountingPersistenceQuery.getDefaultOrderingProperties(clz);
        }
        ArrayList<Expression> selectExpressions = new ArrayList<Expression>();
        selectExpressions.add(Expression.x((String)("SUM(CASE WHEN " + this.getSpecializedProperty(clz, orderingProperty) + " IS NOT NULL THEN " + this.getSpecializedProperty(clz, orderingProperty) + " ELSE 1 END )")).as(orderingProperty));
        selectExpressions.add(Expression.x((String)("(CASE WHEN " + this.getSpecializedProperty(clz, key) + " IS NOT NULL THEN " + this.getSpecializedProperty(clz, key) + " ELSE 'UNKNOWN' END )")).as(key));
        Expression whereExpression = Expression.x((String)this.getSpecializedProperty(clz, "scope")).eq(Expression.s((String[])new String[]{currentScope}));
        long startTime = temporalConstraint.getAlignedStartTime().getTimeInMillis();
        whereExpression = whereExpression.and(Expression.x((String)this.getSpecializedProperty(clz, "startTime")).gt(startTime));
        long endTime = temporalConstraint.getEndTime();
        whereExpression = whereExpression.and(Expression.x((String)this.getSpecializedProperty(clz, "endTime")).lt(endTime));
        SortedSet recordKeysSet = AccountingPersistenceQuery.getQuerableKeys(clz);
        TreeSet<String> keys = new TreeSet<String>();
        if (filters != null && filters.size() != 0) {
            for (Filter filter : filters) {
                String filterKey = filter.getKey();
                String filterValue = filter.getValue();
                if (filterKey != null && filterKey.compareTo(MAP_REDUCE__DESIGN) != 0 && recordKeysSet.contains(filterKey)) {
                    if (filterValue != null && filterValue.compareTo(MAP_REDUCE__DESIGN) != 0) {
                        if (keys.contains(filterKey)) {
                            throw new DuplicatedKeyFilterException("Only one value per Filter key is allowed");
                        }
                        whereExpression = whereExpression.and(Expression.x((String)this.getSpecializedProperty(clz, filterKey)).eq(Expression.s((String[])new String[]{filterValue})));
                        keys.add(filterKey);
                        continue;
                    }
                    throw new KeyException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
                }
                throw new ValueException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
            }
        }
        Expression[] selectExpressionArray = new Expression[selectExpressions.size()];
        selectExpressions.toArray(selectExpressionArray);
        Sort sort = Sort.desc((String)orderingProperty);
        Bucket bucket = this.getBucket(clz);
        LimitPath path = Select.select((Expression[])selectExpressionArray).from(bucket.name()).where(whereExpression).groupBy(new String[]{key}).orderBy(new Sort[]{sort});
        logger.debug("Query for top:" + path.toString());
        Comparator<NumberedFilter> comparator = new Comparator<NumberedFilter>(){

            @Override
            public int compare(NumberedFilter o1, NumberedFilter o2) {
                int compareResult = -o1.compareTo(o2);
                if (compareResult == 0) {
                    compareResult = 1;
                }
                return compareResult;
            }
        };
        TreeSet<NumberedFilter> ret = new TreeSet<NumberedFilter>(comparator);
        N1qlQueryResult result = bucket.query((Statement)path);
        if (!result.finalSuccess()) {
            logger.debug("{} failed : {}", (Object)N1qlQueryResult.class.getSimpleName(), (Object)result.errors());
            throw new Exception("Query Failed :\n" + result.errors());
        }
        List rows = result.allRows();
        for (N1qlQueryRow row : rows) {
            try {
                JsonObject jsonObject = row.value();
                String value = jsonObject.getString(key);
                Number n = jsonObject.getDouble(orderingProperty);
                if (n == null) {
                    n = 0;
                }
                NumberedFilter numberedFilter = new NumberedFilter(key, value, n, orderingProperty);
                ret.add(numberedFilter);
            }
            catch (Exception e) {
                logger.warn("Unable to eleborate result for {}", (Object)row.toString());
                e.printStackTrace();
            }
        }
        return ret;
    }

    public SortedMap<Filter, SortedMap<Calendar, Info>> getContextTimeSeries(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, List<String> contexts) throws Exception {
        logger.trace("getContextTimeSeries for contexts:{}", (Object)contexts.toString());
        TreeSet<Filter> listContexts = new TreeSet<Filter>();
        for (String context : contexts) {
            Filter contextLabel = new Filter("context", context);
            listContexts.add(contextLabel);
        }
        TreeMap<Filter, SortedMap<Calendar, Info>> ret = new TreeMap<Filter, SortedMap<Calendar, Info>>();
        for (Filter nf : listContexts) {
            logger.debug("detail time series :{}", (Object)nf.toString());
            SortedMap<Calendar, Info> map = this.mapReduceQuery(clz, temporalConstraint, filters, nf.getValue(), false, false);
            if (!map.isEmpty()) {
                ret.put(nf, map);
            }
            filters.remove(nf);
        }
        return ret;
    }

    protected String getQualifiedProperty(String property) {
        return property;
    }

    protected String getSpecializedProperty(Class<? extends AggregatedRecord<?, ?>> clz, String property) throws Exception {
        Bucket bucket = this.getBucket(clz);
        return String.format("%s.%s", bucket.name(), property);
    }

    @Deprecated
    public SortedSet<NumberedFilter> getFilterValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String key) throws Exception {
        return this.getFilterValues(clz, temporalConstraint, filters, key, null);
    }

    public SortedSet<NumberedFilter> getFilterValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String key, Integer limit) throws Exception {
        ViewResult viewResult;
        int scopeDateGroupLevel;
        String currentScope = AccountingPersistenceBackendQuery.getScopeToQuery();
        JsonArray startKey = JsonArray.create();
        startKey.add(currentScope);
        int groupLevel = scopeDateGroupLevel = 2;
        String designDocId = this.getDesignDocId(clz) + "Value";
        String viewName = key;
        logger.trace("designDocId:{} view:{} startKey:{} groupLevel:{}", new Object[]{designDocId, key, startKey, groupLevel});
        ViewQuery query = ViewQuery.from((String)designDocId, (String)viewName);
        query.inclusiveEnd();
        query.groupLevel(groupLevel);
        query.startKey(startKey);
        query.descending(false);
        if (limit != null) {
            query.limit(limit.intValue());
        }
        String orderingProperty = AccountingPersistenceQuery.getDefaultOrderingProperties(clz);
        Bucket bucket = this.getBucket(clz);
        try {
            viewResult = bucket.query(query);
        }
        catch (Exception e) {
            logger.error("error executing the query", (Throwable)e);
            throw e;
        }
        Comparator<NumberedFilter> comparator = new Comparator<NumberedFilter>(){

            @Override
            public int compare(NumberedFilter o1, NumberedFilter o2) {
                if (o1.getValue() == null) {
                    o1.setValue(AccountingPersistenceQueryCouchBase.MAP_REDUCE__DESIGN);
                }
                if (o2.getValue() == null) {
                    o2.setValue(AccountingPersistenceQueryCouchBase.MAP_REDUCE__DESIGN);
                }
                return o1.getValue().compareTo(o2.getValue());
            }
        };
        TreeSet<NumberedFilter> ret = new TreeSet<NumberedFilter>(comparator);
        for (ViewRow row : viewResult) {
            String value = (String)row.value();
            NumberedFilter numberedFilter = new NumberedFilter(key, value, (Number)0, orderingProperty);
            ret.add(numberedFilter);
        }
        logger.trace("returning {} values", (Object)ret.size());
        return ret;
    }

    public JSONObject getUsageValue(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, Filter applicant) throws Exception {
        ViewResult viewResult;
        int scopeDateGroupLevel;
        String currentScope = AccountingPersistenceBackendQuery.getScopeToQuery();
        JsonArray startKey = JsonArray.create();
        startKey.add(currentScope);
        JsonArray endKey = JsonArray.create();
        endKey.add(currentScope);
        TemporalConstraint.AggregationMode aggregationMode = temporalConstraint.getAggregationMode();
        JsonArray temporalStartKey = this.getRangeKey(temporalConstraint.getStartTime(), aggregationMode, false, false);
        JsonArray temporalEndKey = this.getRangeKey(temporalConstraint.getEndTime(), aggregationMode, false, false);
        startKey.add(applicant.getValue());
        for (Object temporal : temporalStartKey.toList()) {
            if (temporal.toString().isEmpty()) continue;
            startKey.add(temporal);
        }
        endKey.add(applicant.getValue());
        int count = 1;
        for (Object temporal : temporalEndKey.toList()) {
            if (!temporal.toString().isEmpty()) {
                if (count == temporalEndKey.size()) {
                    temporal = (Integer)temporal + 1;
                }
                endKey.add(temporal);
            }
            ++count;
        }
        int groupLevel = scopeDateGroupLevel = aggregationMode.ordinal() + 1 + 1 + 1;
        TreeSet<String> keys = new TreeSet<String>();
        keys.add(applicant.getKey());
        String designDocId = this.getDesignDocIdSpecific(clz, keys);
        String viewName = applicant.getKey();
        ViewQuery query = ViewQuery.from((String)designDocId, (String)viewName);
        query.inclusiveEnd();
        query.groupLevel(groupLevel);
        query.startKey(startKey);
        query.endKey(endKey);
        query.descending(false);
        logger.trace("Bucket :{}, Design Doc ID : {}, View Name : {}, Group Level : {}, Start Key : {}, End Key : {},temporalStartKey :{}, temporalEndKey :{}", new Object[]{clz.getSimpleName(), designDocId, viewName, groupLevel, startKey, endKey, temporalStartKey.toString(), temporalEndKey.toString()});
        Bucket bucket = this.getBucket(clz);
        try {
            viewResult = bucket.query(query);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
            throw e;
        }
        HashMap<String, Float> map = new HashMap<String, Float>();
        for (ViewRow row : viewResult) {
            JsonObject jsnobject = (JsonObject)row.value();
            JSONObject objJson = new JSONObject(jsnobject.toString());
            Iterator iterateJosn = objJson.keys();
            while (iterateJosn.hasNext()) {
                String key = (String)iterateJosn.next();
                Float valuetmp = Float.valueOf(Float.parseFloat(objJson.get(key).toString()));
                if (!key.equals("operationCount") && !key.equals("dataVolume")) continue;
                if (map.containsKey(key)) {
                    map.put(key, Float.valueOf(valuetmp.floatValue() + ((Float)map.get(key)).floatValue()));
                    continue;
                }
                map.put(key, valuetmp);
            }
        }
        JSONObject result = new JSONObject(map);
        return result;
    }

    public List<UsageValue> getUsageValueQuotaTotal(List<UsageValue> listUsage) throws Exception {
        logger.debug("getUsageValueQuotaTotal init with list:{}", listUsage);
        String keyOrderingProperty = null;
        for (UsageValue totalFilters : listUsage) {
            ViewResult viewResult;
            Object temporal2;
            String currentScope = totalFilters.getContext();
            TreeSet<String> keys = new TreeSet<String>();
            keys.add("consumerId");
            String designDocId = this.getDesignDocIdSpecific(totalFilters.getClz(), keys);
            JsonArray temporalStartKey = null;
            JsonArray temporalEndKey = null;
            logger.trace("temporalConstraint:{}", (Object)totalFilters);
            TemporalConstraint temporalConstraint = totalFilters.getTemporalConstraint();
            if (temporalConstraint == null) {
                logger.trace("Not found temporalConstraint");
                Calendar startTime = Calendar.getInstance();
                startTime.set(1970, 0, 1);
                Calendar endTime = Calendar.getInstance();
                temporalConstraint = new TemporalConstraint(startTime.getTimeInMillis(), endTime.getTimeInMillis(), TemporalConstraint.AggregationMode.DAILY);
                if (totalFilters instanceof UsageStorageValue) {
                    designDocId = "QuotaTotalSeparated";
                }
            } else if (totalFilters.getClz().getSimpleName().equals(AggregatedStorageStatusRecord.class.getSimpleName())) {
                logger.trace("AggregatedStorageStatusRecord with temporalConstraint");
                designDocId = "Quota";
            }
            TemporalConstraint.AggregationMode aggregationMode = temporalConstraint.getAggregationMode();
            temporalStartKey = this.getRangeKey(temporalConstraint.getStartTime(), aggregationMode, false, false);
            temporalEndKey = this.getRangeKey(temporalConstraint.getEndTime(), aggregationMode, false, false);
            Double totalQuota = 0.0;
            String viewNameTmp = null;
            JsonArray startKeyTmp = JsonArray.create();
            startKeyTmp.add(currentScope);
            JsonArray endKeyTmp = JsonArray.create();
            endKeyTmp.add(currentScope);
            int groupLevelTmp = 2;
            viewNameTmp = "consumerId";
            startKeyTmp.add(totalFilters.getIdentifier());
            endKeyTmp.add(totalFilters.getIdentifier());
            if (totalFilters instanceof UsageServiceValue) {
                UsageServiceValue totalFiltersService = (UsageServiceValue)totalFilters;
                for (Filter filter : totalFiltersService.getFilters()) {
                    viewNameTmp = viewNameTmp + KEYS_SEPARATOR + filter.getKey();
                    startKeyTmp.add(filter.getValue());
                    endKeyTmp.add(filter.getValue());
                    ++groupLevelTmp;
                }
            }
            for (Object temporal2 : temporalStartKey.toList()) {
                if (temporal2.toString().isEmpty()) continue;
                startKeyTmp.add(temporal2);
            }
            int count = 1;
            temporal2 = temporalEndKey.toList().iterator();
            while (temporal2.hasNext()) {
                Object temporal3 = temporal2.next();
                if (!temporal3.toString().isEmpty()) {
                    if (count == temporalEndKey.size()) {
                        temporal3 = (Integer)temporal3 + 1;
                    }
                    endKeyTmp.add(temporal3);
                }
                ++count;
            }
            logger.trace("Bucket :{}, Design Doc ID : {}, View Name : {}, Group Level : {}, Start Key : {}, End Key : {},temporalStartKey :{}, temporalEndKey :{}", new Object[]{totalFilters.getClz().getSimpleName(), designDocId, viewNameTmp, groupLevelTmp, startKeyTmp, endKeyTmp, temporalStartKey.toString(), temporalEndKey.toString()});
            ViewQuery query = ViewQuery.from((String)designDocId, (String)viewNameTmp);
            query.inclusiveEnd();
            query.groupLevel(groupLevelTmp);
            query.startKey(startKeyTmp);
            query.endKey(endKeyTmp);
            query.descending(false);
            query.onError(OnError.STOP);
            logger.trace("query row:{}", (Object)query.toString());
            Bucket bucket = this.getBucket(totalFilters.getClz());
            try {
                viewResult = bucket.query(query);
            }
            catch (Exception e) {
                logger.error(e.getLocalizedMessage());
                throw e;
            }
            logger.trace("viewResult row:{}", (Object)viewResult.toString());
            HashMap<String, Float> map = new HashMap<String, Float>();
            for (ViewRow row : viewResult) {
                logger.trace("ViewRow row:{}", (Object)row.toString());
                JsonObject jsnobject = (JsonObject)row.value();
                JSONObject objJson = new JSONObject(jsnobject.toString());
                Iterator iterateJosn = objJson.keys();
                while (iterateJosn.hasNext()) {
                    String key = (String)iterateJosn.next();
                    if (totalFilters instanceof UsageStorageValue) {
                        JSONArray valueStorage = (JSONArray)objJson.get(key);
                        logger.debug("--storageUsageRecord -key:{} value:{}", (Object)key, valueStorage.get(0));
                        totalQuota = totalQuota + (double)Float.parseFloat(valueStorage.get(0).toString());
                        keyOrderingProperty = "dataVolume";
                        continue;
                    }
                    if (!key.equals("operationCount") && !key.equals("dataVolume")) continue;
                    Float valuetmp = Float.valueOf(Float.parseFloat(objJson.get(key).toString()));
                    if (map.containsKey(key)) {
                        map.put(key, Float.valueOf(valuetmp.floatValue() + ((Float)map.get(key)).floatValue()));
                        logger.debug("?UsageRecord -designDocId:{}", (Object)designDocId);
                        keyOrderingProperty = key;
                        totalQuota = totalQuota + (totalFilters.getD() + valuetmp.doubleValue());
                        continue;
                    }
                    map.put(key, valuetmp);
                    logger.debug("?UsageRecord -designDocId:{}", (Object)designDocId);
                    keyOrderingProperty = key;
                    totalQuota = totalQuota + valuetmp.doubleValue();
                }
            }
            if (totalFilters instanceof UsageStorageValue) {
                totalQuota = totalQuota / 1024.0 / 1024.0;
                totalQuota = (double)Math.round(totalQuota * 100.0) / 100.0;
            }
            totalFilters.setOrderingProperty(keyOrderingProperty);
            if (totalQuota.isNaN()) {
                totalQuota = 0.0;
            }
            totalFilters.setD(totalQuota);
        }
        return listUsage;
    }

    public String getRecord(String recordId, String recordType) throws Exception {
        try {
            Bucket bucket = this.getBucket(recordType);
            JsonDocument recordJson = bucket.get(recordId);
            return ((JsonObject)recordJson.content()).toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public SortedSet<String> getSpaceProvidersIds() throws Exception {
        ViewResult viewResult;
        int scopeDateGroupLevel;
        String currentScope = AccountingPersistenceBackendQuery.getScopeToQuery();
        JsonArray startKey = JsonArray.create();
        startKey.add(currentScope);
        int groupLevel = scopeDateGroupLevel = 2;
        String designDocId = "StorageStatusRecordValue";
        String viewName = "providerId";
        logger.trace("designDocId:{} view:{} startKey:{} groupLevel:{}", new Object[]{designDocId, viewName, startKey, groupLevel});
        ViewQuery query = ViewQuery.from((String)designDocId, (String)viewName);
        query.inclusiveEnd();
        query.groupLevel(groupLevel);
        query.startKey(startKey);
        query.descending(false);
        TreeSet<String> ret = new TreeSet<String>();
        Bucket bucket = this.getBucket(AggregatedStorageStatusRecord.class);
        try {
            viewResult = bucket.query(query);
        }
        catch (Exception e) {
            logger.error("error executing the query", (Throwable)e);
            throw e;
        }
        for (ViewRow row : viewResult) {
            String value = (String)row.value();
            ret.add(value);
        }
        return ret;
    }

    public SortedMap<Filter, SortedMap<Calendar, Long>> getSpaceTimeSeries(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, List<String> providersId) throws Exception {
        ViewResult viewResult;
        String currentScope = AccountingPersistenceBackendQuery.getScopeToQuery();
        JsonArray startKey = JsonArray.create();
        JsonArray endKey = JsonArray.create();
        startKey.add(currentScope);
        endKey.add(currentScope);
        TemporalConstraint.AggregationMode aggregationMode = temporalConstraint.getAggregationMode();
        JsonArray temporalStartKey = this.getRangeKey(temporalConstraint.getStartTime(), aggregationMode, false, false);
        JsonArray temporalEndKey = this.getRangeKey(temporalConstraint.getEndTime(), aggregationMode, false, false);
        TreeSet<String> keys = new TreeSet<String>();
        String designDocId = "StorageStatusUsage";
        int groupLevel = 5;
        if (temporalConstraint.getAggregationMode().equals((Object)TemporalConstraint.AggregationMode.MONTHLY)) {
            groupLevel = 4;
        }
        if (temporalConstraint.getAggregationMode().equals((Object)TemporalConstraint.AggregationMode.YEARLY)) {
            groupLevel = 3;
        }
        String viewName = temporalConstraint.getAggregationMode().name().toLowerCase();
        if (filters != null && filters.size() != 0) {
            Collections.sort(filters, new Comparator<Filter>(){

                @Override
                public int compare(Filter filter1, Filter filter2) {
                    int result = filter1.getKey().compareTo(filter2.getKey());
                    return result;
                }
            });
            for (Filter filter : filters) {
                String filterKey = filter.getKey();
                String filterValue = filter.getValue();
                if (filterKey != null && filterKey.compareTo(MAP_REDUCE__DESIGN) != 0) {
                    if (filterValue != null && filterValue.compareTo(MAP_REDUCE__DESIGN) != 0) {
                        if (keys.contains(filterKey)) {
                            throw new DuplicatedKeyFilterException("Only one value per Filter key is allowed");
                        }
                        startKey.add(filterValue);
                        endKey.add(filterValue);
                        keys.add(filterKey);
                        viewName = viewName + "_" + filterKey;
                        if (filterKey == "consumerId") continue;
                        ++groupLevel;
                        continue;
                    }
                    throw new KeyException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
                }
                throw new ValueException(String.format("Invalid %s : %s", Filter.class.getSimpleName(), filter.toString()));
            }
        }
        for (Object temporal : temporalStartKey.toList()) {
            if (temporal.toString().isEmpty()) continue;
            startKey.add(temporal);
        }
        int count = 1;
        for (Object temporal : temporalEndKey.toList()) {
            if (!temporal.toString().isEmpty()) {
                if (count == temporalEndKey.size()) {
                    temporal = (Integer)temporal + 1;
                }
                endKey.add(temporal);
            }
            ++count;
        }
        ViewQuery query = ViewQuery.from((String)designDocId, (String)viewName);
        query.inclusiveEnd();
        query.groupLevel(groupLevel);
        query.startKey(startKey);
        query.endKey(endKey);
        query.descending(false);
        logger.trace("Bucket :{}, Design Doc ID : {}, View Name : {}, Group Level : {}, Start Key : {}, End Key : {},temporalStartKey :{}, temporalEndKey :{}", new Object[]{clz.getSimpleName(), designDocId, viewName, groupLevel, startKey, endKey, temporalStartKey.toString(), temporalEndKey.toString()});
        Bucket bucket = this.getBucket(clz);
        try {
            viewResult = bucket.query(query);
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage());
            throw e;
        }
        TreeMap<Filter, SortedMap<Calendar, Long>> ret = new TreeMap<Filter, SortedMap<Calendar, Long>>();
        for (ViewRow row : viewResult) {
            JsonArray array = (JsonArray)row.key();
            Calendar calendar = this.getCalendarFromArray(array);
            JsonObject value = (JsonObject)row.value();
            JSONObject obj = new JSONObject(value.toString());
            Iterator iterator = obj.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String[] tmp = key.split("-");
                String providerId = tmp[0];
                if (!providersId.contains(providerId)) continue;
                Long valueProvider = Long.parseLong(obj.get(key).toString().split(",")[0].replace("[", MAP_REDUCE__DESIGN));
                valueProvider = valueProvider / 1024L;
                Filter filter = new Filter("providerId", providerId);
                if (!ret.containsKey(filter)) {
                    TreeMap<Calendar, Long> infos = new TreeMap<Calendar, Long>();
                    infos.put(calendar, valueProvider);
                    ret.put(filter, infos);
                    continue;
                }
                SortedMap singleValue = (SortedMap)ret.get(filter);
                if (!singleValue.containsKey(calendar)) {
                    singleValue.put(calendar, valueProvider);
                    continue;
                }
                singleValue.put(calendar, (Long)singleValue.get(calendar) + valueProvider);
            }
        }
        logger.trace("return ret:{}", (Object)((Object)ret).toString());
        return ret;
    }

    static {
        MAX_REQUEST_LIFE_TIME = TimeUnit.MINUTES.toMillis(2L);
        KEEP_ALIVE_INTERVAL = TimeUnit.HOURS.toMillis(1L);
        AUTO_RELEASE_AFTER = TimeUnit.HOURS.toMillis(1L);
        VIEW_TIMEOUT_BUCKET = TimeUnit.MINUTES.toMillis(2L);
        CONNECTION_TIMEOUT_BUCKET = TimeUnit.SECONDS.toMillis(15L);
        CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);
        ENV = DefaultCouchbaseEnvironment.builder().connectTimeout(CONNECTION_TIMEOUT).maxRequestLifetime(MAX_REQUEST_LIFE_TIME).queryTimeout(CONNECTION_TIMEOUT).viewTimeout(VIEW_TIMEOUT_BUCKET).keepAliveInterval(KEEP_ALIVE_INTERVAL).kvTimeout(5000L).autoreleaseAfter(AUTO_RELEASE_AFTER).build();
        RecordUtility.addRecordPackage((Package)ServiceUsageRecord.class.getPackage());
        RecordUtility.addRecordPackage((Package)AggregatedServiceUsageRecord.class.getPackage());
    }
}

