/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.ektorp.DbAccessException;
import org.ektorp.ViewResultException;

public class QueryResultParser<T> {
    private static final String ROWS_FIELD_NAME = "rows";
    private static final String VALUE_FIELD_NAME = "value";
    private static final String ID_FIELD_NAME = "id";
    private static final String ERROR_FIELD_NAME = "error";
    private static final String KEY_FIELD_NAME = "key";
    private static final String INCLUDED_DOC_FIELD_NAME = "doc";
    private static final String TOTAL_ROWS_FIELD_NAME = "total_rows";
    private static final String OFFSET_FIELD_NAME = "offset";
    private int totalRows = -1;
    private int offset = -1;
    private List<T> rows;
    private String firstId;
    private JsonNode firstKey;
    private String lastId;
    private JsonNode lastKey;
    private final ObjectMapper mapper;
    private final Class<T> type;
    private boolean ignoreNotFound;

    public QueryResultParser(Class<T> type, ObjectMapper mapper) {
        this.type = type;
        this.mapper = mapper;
    }

    public void parseResult(InputStream json) throws JsonParseException, IOException {
        JsonParser jp = this.mapper.getJsonFactory().createJsonParser(json);
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new RuntimeException("Expected data to start with an Object");
        }
        Map<String, String> fields = this.readHeaderFields(jp);
        this.assertNoErrors(fields);
        if (fields.containsKey(OFFSET_FIELD_NAME)) {
            this.offset = Integer.parseInt(fields.get(OFFSET_FIELD_NAME));
        }
        if (fields.containsKey(TOTAL_ROWS_FIELD_NAME)) {
            this.totalRows = Integer.parseInt(fields.get(TOTAL_ROWS_FIELD_NAME));
            if (this.totalRows == 0) {
                this.rows = Collections.emptyList();
                return;
            }
        }
        this.rows = new ArrayList<T>();
        ParseState state = new ParseState();
        T first = this.parseFirstRow(jp, state);
        if (first == null) {
            this.rows = Collections.emptyList();
        } else {
            this.rows.add(first);
        }
        while (jp.getCurrentToken() != null) {
            this.skipToField(jp, state.docFieldName, state);
            this.lastId = state.lastId;
            this.lastKey = state.lastKey;
            if (this.atEndOfRows(jp)) {
                return;
            }
            if (!state.fieldIsNull) {
                this.rows.add(jp.readValueAs(this.type));
            }
            this.endRow(jp, state);
        }
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public int getOffset() {
        return this.offset;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public void setIgnoreNotFound(boolean b) {
        this.ignoreNotFound = b;
    }

    private void assertNoErrors(Map<String, String> fields) {
        if (fields.containsKey(ERROR_FIELD_NAME)) {
            JsonNode error = this.mapper.convertValue(fields, JsonNode.class);
            throw new DbAccessException(error.toString());
        }
    }

    private T parseFirstRow(JsonParser jp, ParseState state) throws JsonParseException, IOException, JsonProcessingException, JsonMappingException {
        this.skipToField(jp, VALUE_FIELD_NAME, state);
        this.firstId = state.lastId;
        this.firstKey = state.lastKey;
        JsonNode value = null;
        if (this.atObjectStart(jp)) {
            value = jp.readValueAsTree();
            jp.nextToken();
            if (this.isEndOfRow(jp)) {
                state.docFieldName = VALUE_FIELD_NAME;
                T doc = this.mapper.readValue(value, this.type);
                this.endRow(jp, state);
                return doc;
            }
        }
        this.skipToField(jp, INCLUDED_DOC_FIELD_NAME, state);
        if (this.atObjectStart(jp)) {
            state.docFieldName = INCLUDED_DOC_FIELD_NAME;
            T doc = jp.readValueAs(this.type);
            this.endRow(jp, state);
            return doc;
        }
        return null;
    }

    private boolean isEndOfRow(JsonParser jp) {
        return jp.getCurrentToken() == JsonToken.END_OBJECT;
    }

    private void endRow(JsonParser jp, ParseState state) throws IOException, JsonParseException {
        state.inRow = false;
        jp.nextToken();
    }

    private boolean atObjectStart(JsonParser jp) {
        return jp.getCurrentToken() == JsonToken.START_OBJECT;
    }

    private boolean atEndOfRows(JsonParser jp) {
        return jp.getCurrentToken() != JsonToken.START_OBJECT && jp.getCurrentToken() != JsonToken.END_OBJECT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void skipToField(JsonParser jp, String fieldName, ParseState state) throws JsonParseException, IOException {
        String lastFieldName = null;
        block4: while (jp.getCurrentToken() != null) {
            switch (jp.getCurrentToken()) {
                case FIELD_NAME: {
                    lastFieldName = jp.getCurrentName();
                    jp.nextToken();
                    continue block4;
                }
                case START_OBJECT: {
                    if (!state.inRow) {
                        state.inRow = true;
                        jp.nextToken();
                        continue block4;
                    }
                    if (this.isInField(fieldName, lastFieldName)) {
                        state.fieldIsNull = false;
                        return;
                    }
                    jp.skipChildren();
                    continue block4;
                }
            }
            if (this.isInField(ID_FIELD_NAME, lastFieldName)) {
                state.lastId = jp.readValueAsTree().getTextValue();
            } else if (this.isInField(KEY_FIELD_NAME, lastFieldName)) {
                state.lastKey = jp.readValueAsTree();
            } else if (this.isInField(ERROR_FIELD_NAME, lastFieldName)) {
                JsonNode error = jp.readValueAsTree();
                if (!this.ignoreNotFound || !error.asText().equals("not_found")) throw new ViewResultException(state.lastKey, error.asText());
                lastFieldName = null;
                state.inRow = false;
                jp.nextToken();
            } else if (this.isInField(fieldName, lastFieldName)) {
                state.fieldIsNull = jp.getCurrentToken() == JsonToken.VALUE_NULL;
                jp.nextToken();
                return;
            }
            jp.nextToken();
        }
    }

    private boolean isInField(String fieldName, String lastFieldName) {
        return lastFieldName != null && lastFieldName.equals(fieldName);
    }

    private Map<String, String> readHeaderFields(JsonParser jp) throws JsonParseException, IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        jp.nextToken();
        String nextFieldName = jp.getCurrentName();
        while (nextFieldName != null && !ROWS_FIELD_NAME.equals(nextFieldName)) {
            jp.nextToken();
            map.put(nextFieldName, jp.getText());
            jp.nextToken();
            nextFieldName = jp.getCurrentName();
        }
        return map;
    }

    public String getFirstId() {
        return this.firstId;
    }

    public JsonNode getFirstKey() {
        return this.firstKey;
    }

    public String getLastId() {
        return this.lastId;
    }

    public JsonNode getLastKey() {
        return this.lastKey;
    }

    private static class ParseState {
        public boolean fieldIsNull;
        public String lastId;
        boolean inRow;
        JsonNode lastKey;
        String docFieldName = "";

        private ParseState() {
        }
    }
}

