/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.changes;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ektorp.http.URI;

public class ChangesCommand {
    public final String since;
    public final boolean continuous;
    public final String filter;
    public final boolean includeDocs;
    public final int heartbeat;
    public final int limit;
    public final Map<String, String> extraQueryParams;
    private String queryString;

    private ChangesCommand(Builder b) {
        this.continuous = b.continuous;
        this.since = b.since;
        this.filter = b.filter;
        this.includeDocs = b.includeDocs;
        this.heartbeat = b.heartbeat;
        this.limit = b.limit;
        this.extraQueryParams = b.extraQueryParams != null ? Collections.unmodifiableMap(new LinkedHashMap(b.extraQueryParams)) : null;
    }

    public String toString() {
        if (this.queryString == null) {
            URI uri = URI.of("_changes");
            if (this.continuous) {
                uri.param("feed", "continuous");
            }
            if (this.since != null) {
                uri.param("since", this.since);
            }
            if (this.filter != null) {
                uri.param("filter", this.filter);
            }
            if (this.includeDocs) {
                uri.param("include_docs", "true");
            }
            if (this.heartbeat > 0) {
                uri.param("heartbeat", this.heartbeat);
            }
            if (this.limit > -1) {
                uri.param("limit", this.limit);
            }
            if (this.extraQueryParams != null) {
                uri.params(this.extraQueryParams);
            }
            this.queryString = uri.toString();
        }
        return this.queryString;
    }

    public static class Builder {
        private String since;
        private boolean continuous;
        private String filter;
        private boolean includeDocs;
        private int heartbeat = -1;
        private int limit = -1;
        private Map<String, String> extraQueryParams;

        public Builder since(long l) {
            this.since = Long.toString(l);
            return this;
        }

        public Builder since(String s) {
            this.since = s;
            return this;
        }

        public Builder param(String name, String value) {
            if (this.extraQueryParams == null) {
                this.extraQueryParams = new LinkedHashMap<String, String>();
            }
            this.extraQueryParams.put(name, value);
            return this;
        }

        public Builder continuous(boolean b) {
            this.continuous = b;
            return this;
        }

        public Builder filter(String s) {
            this.filter = s;
            return this;
        }

        public Builder includeDocs(boolean b) {
            this.includeDocs = b;
            return this;
        }

        public Builder heartbeat(int i) {
            this.heartbeat = i;
            return this;
        }

        public Builder limit(int i) {
            this.limit = i;
            return this;
        }

        public Builder merge(ChangesCommand other) {
            this.continuous = other.continuous;
            this.filter = other.filter;
            this.includeDocs = other.includeDocs;
            this.since = other.since;
            this.limit = other.limit;
            if (other.extraQueryParams != null) {
                this.extraQueryParams = new LinkedHashMap<String, String>(other.extraQueryParams);
            }
            return this;
        }

        public ChangesCommand build() {
            return new ChangesCommand(this);
        }
    }
}

