/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.analytics.persistence.postgresql;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.NumberedFilter;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.analytics.UsageValue;
import org.gcube.accounting.analytics.exception.DuplicatedKeyFilterException;
import org.gcube.accounting.analytics.exception.KeyException;
import org.gcube.accounting.analytics.exception.ValueException;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQueryConfiguration;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQuery;
import org.gcube.accounting.analytics.persistence.postgresql.Query;
import org.gcube.accounting.datamodel.aggregation.AggregatedServiceUsageRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedStorageStatusRecord;
import org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord;
import org.gcube.accounting.utility.postgresql.RecordToDBConnection;
import org.gcube.accounting.utility.postgresql.RecordToDBFields;
import org.gcube.accounting.utility.postgresql.RecordToDBMapping;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingPersistenceQueryPostgreSQL
implements AccountingPersistenceBackendQuery {
    protected static final Logger logger = LoggerFactory.getLogger(AccountingPersistenceQueryPostgreSQL.class);
    public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS Z";
    public static final String URL_PROPERTY_KEY = "URL";
    protected AccountingPersistenceBackendQueryConfiguration configuration;

    protected Connection getConnection(Class<? extends AggregatedRecord<?, ?>> clz) throws Exception {
        RecordToDBConnection recordDBInfo = RecordToDBMapping.getRecordDBInfo(clz);
        if (recordDBInfo == null) {
            RecordToDBMapping.addRecordToDB(clz, (PersistenceBackendConfiguration)this.configuration);
            recordDBInfo = RecordToDBMapping.getRecordDBInfo(clz);
        }
        return recordDBInfo.getConnection();
    }

    public void prepareConnection(AccountingPersistenceBackendQueryConfiguration configuration) throws Exception {
        this.configuration = configuration;
        Map aggregatedRecords = RecordUtility.getAggregatedRecordClassesFound();
        for (String typeName : aggregatedRecords.keySet()) {
            try {
                Class clz = (Class)aggregatedRecords.get(typeName);
                RecordToDBMapping.addRecordToDB((Class)clz, (PersistenceBackendConfiguration)configuration);
            }
            catch (Exception e) {
                new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SortedMap<Calendar, Info> getTimeSeries(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, Set<String> contexts) throws Exception {
        try (Connection connection = this.getConnection(clz);){
            Statement statement = connection.createStatement();
            TreeMap<Calendar, Info> result = new TreeMap<Calendar, Info>();
            Query query = new Query(clz);
            query.setTemporalConstraint(temporalConstraint);
            query.setFilters(filters);
            query.setContexts(contexts);
            String sql = query.getTimeSeriesQuery();
            Set<String> requestedTableField = query.getRequestedTableField();
            RecordToDBFields recordToDBMapper = query.getRecordToDBMapper();
            logger.trace("Going to request the following query: {}", (Object)sql);
            ResultSet resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                String tableFieldName = recordToDBMapper.getTableField("startTime");
                OffsetDateTime offsetDateTime = resultSet.getObject(tableFieldName, OffsetDateTime.class);
                Calendar calendar = this.getCalendar(offsetDateTime);
                JSONObject jsonObject = new JSONObject();
                for (String tableField : requestedTableField) {
                    String usageRecordField = recordToDBMapper.getRecordField(tableField);
                    Object object = resultSet.getObject(tableField);
                    jsonObject.put(usageRecordField, object);
                }
                Info info = new Info(calendar, jsonObject);
                result.put(calendar, info);
            }
            TreeMap<Calendar, Info> treeMap = result;
            return treeMap;
        }
    }

    public SortedMap<Calendar, Info> getTimeSeries(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters) throws DuplicatedKeyFilterException, KeyException, ValueException, Exception {
        String context = AccountingPersistenceBackendQuery.getScopeToQuery();
        HashSet<String> contexts = new HashSet<String>();
        contexts.add(context);
        return this.getTimeSeries(clz, temporalConstraint, filters, contexts);
    }

    protected Calendar getCalendar(OffsetDateTime offsetDateTime) {
        Calendar calendar = Calendar.getInstance();
        long epochMillis = offsetDateTime.toInstant().toEpochMilli();
        calendar.setTimeInMillis(epochMillis);
        return calendar;
    }

    public SortedMap<Calendar, Info> getNoContextTimeSeries(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters) throws DuplicatedKeyFilterException, KeyException, ValueException, Exception {
        return this.getTimeSeries(clz, temporalConstraint, filters, null);
    }

    public SortedMap<Filter, SortedMap<Calendar, Info>> getContextTimeSeries(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, List<String> contexts) throws Exception {
        TreeMap<Filter, SortedMap<Calendar, Info>> ret = new TreeMap<Filter, SortedMap<Calendar, Info>>();
        for (String context : contexts) {
            Filter contextFilter = new Filter("context", context);
            HashSet<String> timeSeriesContexts = new HashSet<String>();
            timeSeriesContexts.add(context);
            SortedMap<Calendar, Info> timeSeries = this.getTimeSeries(clz, temporalConstraint, filters, timeSeriesContexts);
            if (timeSeries.isEmpty()) continue;
            ret.put(contextFilter, timeSeries);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SortedSet<NumberedFilter> getNumberedValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String key, String orderingProperty, Integer limit) throws Exception {
        try (Connection connection = this.getConnection(clz);){
            Statement statement = connection.createStatement();
            if (orderingProperty == null) {
                orderingProperty = AccountingPersistenceQuery.getDefaultOrderingProperties(clz);
            }
            if (limit == null) {
                limit = 50;
            }
            TreeSet<NumberedFilter> result = new TreeSet<NumberedFilter>();
            String context = AccountingPersistenceBackendQuery.getScopeToQuery();
            HashSet<String> contexts = new HashSet<String>();
            contexts.add(context);
            Query query = new Query(clz);
            query.setTemporalConstraint(temporalConstraint);
            query.setFilters(filters);
            query.setContexts(contexts);
            query.setTableFieldToRequest(key);
            query.setOrderByField(orderingProperty);
            query.setLimit(limit);
            String sql = query.getNextPossibleValueQuery();
            RecordToDBFields recordToDBMapper = query.getRecordToDBMapper();
            logger.trace("Going to request the following query: {}", (Object)sql);
            ResultSet resultSet = statement.executeQuery(sql);
            String tableFieldORderingProperty = recordToDBMapper.getTableField(orderingProperty);
            while (resultSet.next()) {
                String tableFieldKey = recordToDBMapper.getTableField(key);
                Object value = resultSet.getObject(tableFieldKey);
                Object numberObject = resultSet.getObject(tableFieldORderingProperty);
                NumberedFilter numberedFilter = new NumberedFilter(key, value.toString(), (Number)numberObject, orderingProperty);
                result.add(numberedFilter);
            }
            TreeSet<NumberedFilter> treeSet = result;
            return treeSet;
        }
    }

    public SortedSet<NumberedFilter> getFilterValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String key) throws Exception {
        return this.getNumberedValues(clz, temporalConstraint, filters, key, null, null);
    }

    public SortedSet<NumberedFilter> getFilterValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String key, Integer limit) throws Exception {
        return this.getNumberedValues(clz, temporalConstraint, filters, key, null, limit);
    }

    public SortedMap<NumberedFilter, SortedMap<Calendar, Info>> getTopValues(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, String topKey, String orderingProperty) throws DuplicatedKeyFilterException, KeyException, ValueException, Exception {
        String context = AccountingPersistenceBackendQuery.getScopeToQuery();
        HashSet<String> contexts = new HashSet<String>();
        contexts.add(context);
        TreeMap<NumberedFilter, SortedMap<Calendar, Info>> ret = new TreeMap<NumberedFilter, SortedMap<Calendar, Info>>();
        SortedSet<NumberedFilter> top = this.getNumberedValues(clz, temporalConstraint, filters, topKey, orderingProperty, 10);
        for (NumberedFilter numberedFilter : top) {
            filters.add((Filter)numberedFilter);
            SortedMap<Calendar, Info> map = this.getTimeSeries(clz, temporalConstraint, filters, contexts);
            ret.put(numberedFilter, map);
            filters.remove(numberedFilter);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record getRecord(String recordId, String type) throws Exception {
        Class aggregatedRecordClass = RecordUtility.getAggregatedRecordClass((String)type);
        try (Connection connection = this.getConnection(aggregatedRecordClass);){
            Statement statement = connection.createStatement();
            Query query = new Query(aggregatedRecordClass);
            query.setRecordId(recordId);
            String sql = query.getRecordQuery();
            RecordToDBFields recordToDBMapper = query.getRecordToDBMapper();
            ResultSet resultSet = statement.executeQuery(sql);
            resultSet.next();
            AggregatedRecord instance = (AggregatedRecord)aggregatedRecordClass.newInstance();
            Set requiredFields = instance.getRequiredFields();
            for (String recordField : requiredFields) {
                Object serializable;
                String tableField = recordToDBMapper.getTableField(recordField);
                switch (recordField) {
                    case "startTime": 
                    case "endTime": 
                    case "creationTime": {
                        OffsetDateTime offsetDateTime = resultSet.getObject(tableField, OffsetDateTime.class);
                        Calendar calendar = this.getCalendar(offsetDateTime);
                        serializable = calendar.getTimeInMillis();
                        break;
                    }
                    default: {
                        serializable = resultSet.getObject(tableField).toString();
                    }
                }
                instance.setResourceProperty(recordField, (Serializable)serializable);
            }
            AggregatedRecord aggregatedRecord = instance;
            return aggregatedRecord;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<String> getSpaceProvidersIds() throws Exception {
        Class<AggregatedStorageStatusRecord> aggregatedRecordClass = AggregatedStorageStatusRecord.class;
        try (Connection connection = this.getConnection(aggregatedRecordClass);){
            Statement statement = connection.createStatement();
            Query query = new Query(aggregatedRecordClass);
            query.setTableFieldToRequest("providerId");
            String sql = query.getDinstinctValuesQuery();
            TreeSet<String> providersIds = new TreeSet<String>();
            logger.trace("Going to request the following query: {}", (Object)sql);
            ResultSet resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                String id = resultSet.getString(1);
                providersIds.add(id);
            }
            TreeSet<String> treeSet = providersIds;
            return treeSet;
        }
    }

    public List<UsageValue> getUsageValueQuotaTotal(List<UsageValue> listUsage) throws Exception {
        return null;
    }

    public SortedMap<Filter, SortedMap<Calendar, Long>> getSpaceTimeSeries(Class<? extends AggregatedRecord<?, ?>> clz, TemporalConstraint temporalConstraint, List<Filter> filters, List<String> providersId) throws Exception {
        return null;
    }

    public void close() throws Exception {
    }

    public boolean isConnectionActive() throws Exception {
        return true;
    }

    static {
        RecordUtility.addRecordPackage((Package)ServiceUsageRecord.class.getPackage());
        RecordUtility.addRecordPackage((Package)AggregatedServiceUsageRecord.class.getPackage());
    }
}

