/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.analytics;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.analytics.exception.NoAvailableScopeException;
import org.gcube.accounting.analytics.exception.NoUsableAccountingPersistenceQueryFound;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQueryFactory;
import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.SingleUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord;
import org.gcube.common.scope.api.ScopeProvider;
import org.json.JSONException;
import org.json.JSONObject;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRecordQuery {
    private static Logger logger = LoggerFactory.getLogger(ResourceRecordQuery.class);
    protected static Map<Class<? extends SingleUsageRecord>, Set<String>> resourceRecords = null;
    protected AccountingPersistenceBackendQuery accountingPersistenceQuery;

    public static synchronized Map<Class<? extends SingleUsageRecord>, Set<String>> getResourceRecordsTypes() {
        if (resourceRecords == null) {
            resourceRecords = new HashMap<Class<? extends SingleUsageRecord>, Set<String>>();
            Package usageRecordPackage = ServiceUsageRecord.class.getPackage();
            Reflections reflections = new Reflections(usageRecordPackage.getName(), new Scanner[0]);
            Set resourceRecordsTypes = reflections.getSubTypesOf(SingleUsageRecord.class);
            for (Class resourceRecordsType : resourceRecordsTypes) {
                try {
                    SingleUsageRecord singleUsageRecord = (SingleUsageRecord)resourceRecordsType.newInstance();
                    resourceRecords.put(resourceRecordsType, singleUsageRecord.getRequiredFields());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    logger.error(String.format("Unable to correctly istantiate %s", resourceRecordsType.getSimpleName()), (Throwable)e);
                }
            }
        }
        return resourceRecords;
    }

    public ResourceRecordQuery() throws NoAvailableScopeException, NoUsableAccountingPersistenceQueryFound {
        this.accountingPersistenceQuery = AccountingPersistenceBackendQueryFactory.getInstance();
    }

    public ResourceRecordQuery(String scope) throws NoAvailableScopeException, NoUsableAccountingPersistenceQueryFound {
        ScopeProvider.instance.set(scope);
        this.accountingPersistenceQuery = AccountingPersistenceBackendQueryFactory.getInstance();
    }

    protected static JSONObject getPaddingJSONObject(Map<Calendar, Info> unpaddedResults) throws JSONException {
        Info auxInfo = new ArrayList<Info>(unpaddedResults.values()).get(0);
        JSONObject auxJsonObject = auxInfo.getValue();
        Iterator keys = auxJsonObject.keys();
        JSONObject jsonObject = new JSONObject();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            jsonObject.put(key, 0);
        }
        return jsonObject;
    }

    public static List<Info> getPaddedResults(Map<Calendar, Info> unpaddedData, TemporalConstraint temporalConstraint) throws Exception {
        JSONObject jsonObject = ResourceRecordQuery.getPaddingJSONObject(unpaddedData);
        ArrayList<Info> paddedResults = new ArrayList<Info>();
        List<Calendar> sequence = temporalConstraint.getCalendarSequence();
        for (Calendar progressTime : sequence) {
            if (unpaddedData.get(progressTime) != null) {
                paddedResults.add(unpaddedData.get(progressTime));
                continue;
            }
            Info info = new Info(progressTime, jsonObject);
            paddedResults.add(info);
        }
        return paddedResults;
    }

    public List<Info> getInfo(Class<? extends AggregatedUsageRecord> usageRecordType, TemporalConstraint temporalConstraint, List<Filter> filters, boolean pad) throws Exception {
        Map<Calendar, Info> unpaddedResults = this.accountingPersistenceQuery.query(usageRecordType, temporalConstraint, filters);
        if (!pad) {
            return new ArrayList<Info>(unpaddedResults.values());
        }
        return ResourceRecordQuery.getPaddedResults(unpaddedResults, temporalConstraint);
    }

    public List<Info> getInfo(Class<? extends AggregatedUsageRecord> usageRecordType, TemporalConstraint temporalConstraint, List<Filter> filters) throws Exception {
        return this.getInfo(usageRecordType, temporalConstraint, filters, false);
    }

    public List<String> getKeys(Class<? extends AggregatedUsageRecord> usageRecordType) throws Exception {
        Set<String> keys = this.accountingPersistenceQuery.getKeys(usageRecordType);
        ArrayList<String> toSort = new ArrayList<String>(keys);
        Collections.sort(toSort);
        return toSort;
    }

    public List<String> getPossibleValuesForKey(Class<? extends AggregatedUsageRecord> usageRecordType, String key) throws Exception {
        Set<String> keys = this.accountingPersistenceQuery.getPossibleValuesForKey(usageRecordType, key);
        ArrayList<String> toSort = new ArrayList<String>(keys);
        Collections.sort(toSort);
        return toSort;
    }
}

