/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.analytics;

import java.util.Calendar;
import java.util.Map;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.Info;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;

public class NumberedFilter
extends Filter {
    protected Double d;
    protected String orderingProperty;

    public NumberedFilter(String key, String value, Number n, String orderingProperty) {
        super(key, value);
        this.d = n.doubleValue();
        this.orderingProperty = orderingProperty;
    }

    public NumberedFilter(Filter filter, Number n, String orderingProperty) {
        this(filter.key, filter.value, n, orderingProperty);
    }

    public NumberedFilter(Filter filter, Map<Calendar, Info> timeSeries, String orderingProperty) throws Exception {
        super(filter.key, filter.value);
        this.d = new Double(0.0);
        this.orderingProperty = orderingProperty;
        for (Info info : timeSeries.values()) {
            JsonNode value = info.getValue();
            if (this.d == null) {
                this.d = value.get(orderingProperty).asDouble();
                continue;
            }
            this.d = this.d + value.get(orderingProperty).asDouble();
        }
    }

    public Double getDouble() {
        return this.d;
    }

    public void setDouble(Double d) {
        this.d = d;
    }

    public String getOrderingProperty() {
        return this.orderingProperty;
    }

    public void setOrderingProperty(String orderingProperty) {
        this.orderingProperty = orderingProperty;
    }

    @Override
    public int compareTo(NumberedFilter numberedFilter) {
        int compareResult = this.d.compareTo(numberedFilter.d);
        return compareResult;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.d == null ? 0 : this.d.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof NumberedFilter)) {
            return false;
        }
        NumberedFilter other = (NumberedFilter)obj;
        return !(this.d == null ? other.d != null : !this.d.equals(other.d));
    }

    @Override
    public String toString() {
        return String.format("%s, %s : %d}", super.toString().replace(" }", ""), this.orderingProperty, this.d.longValue());
    }
}

