/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.analytics;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;

public class TemporalConstraint {
    private static final String UTC_TIME_ZONE = "UTC";
    public static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getTimeZone("UTC");
    protected long startTime;
    protected long endTime;
    protected AggregationMode aggregationMode;

    public TemporalConstraint(long startTime, long endTime, AggregationMode aggregationMode) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.aggregationMode = aggregationMode;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public AggregationMode getAggregationMode() {
        return this.aggregationMode;
    }

    public void setAggregationMode(AggregationMode aggregationMode) {
        this.aggregationMode = aggregationMode;
    }

    public static String timeInMillisToString(long timeInMillis) {
        Date date = new Date(timeInMillis);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SS z");
        simpleDateFormat.setTimeZone(DEFAULT_TIME_ZONE);
        return String.format("%s (%d millis)", simpleDateFormat.format(date), timeInMillis);
    }

    public static Calendar getAlignedCalendar(long millis, AggregationMode aggregationMode) {
        Calendar alignedCalendar = Calendar.getInstance();
        alignedCalendar.setTimeZone(DEFAULT_TIME_ZONE);
        alignedCalendar.setTimeInMillis(millis);
        CalendarEnum[] calendarValues = CalendarEnum.values();
        for (int i = aggregationMode.ordinal() + 1; i < calendarValues.length; ++i) {
            int calendarValue = calendarValues[i].getCalendarValue();
            if (calendarValue == 5) {
                alignedCalendar.set(calendarValue, 1);
                continue;
            }
            alignedCalendar.set(calendarValue, 0);
        }
        return alignedCalendar;
    }

    public Calendar getAlignedStartTime() {
        return TemporalConstraint.getAlignedCalendar(this.startTime, this.aggregationMode);
    }

    public Calendar getAlignedEndTime() {
        Calendar calendar = TemporalConstraint.getAlignedCalendar(this.endTime, this.aggregationMode);
        int calendarToAdd = CalendarEnum.values()[this.aggregationMode.ordinal() + 1].getCalendarValue();
        calendar.add(calendarToAdd, 1);
        calendar.add(14, -1);
        return calendar;
    }

    public SortedSet<Calendar> getCalendarSequence() {
        TreeSet<Calendar> sequence = new TreeSet<Calendar>();
        CalendarEnum[] calendarValues = CalendarEnum.values();
        int calendarValue = calendarValues[this.aggregationMode.ordinal()].getCalendarValue();
        Calendar alignedStartTime = this.getAlignedStartTime();
        Calendar alignedEndTime = this.getAlignedEndTime();
        long alignedEndTimeInMillis = alignedEndTime.getTimeInMillis();
        Calendar progressTime = Calendar.getInstance();
        progressTime.setTimeZone(DEFAULT_TIME_ZONE);
        progressTime.setTimeInMillis(alignedStartTime.getTimeInMillis());
        while (progressTime.getTimeInMillis() <= alignedEndTimeInMillis) {
            Calendar item = Calendar.getInstance();
            item.setTimeZone(DEFAULT_TIME_ZONE);
            item.setTimeInMillis(progressTime.getTimeInMillis());
            sequence.add(item);
            progressTime.add(calendarValue, 1);
        }
        return sequence;
    }

    public static List<String> getSequenceAsStringList(Collection<Calendar> sequence) {
        ArrayList<String> stringSequence = new ArrayList<String>();
        for (Calendar calendar : sequence) {
            stringSequence.add(TemporalConstraint.timeInMillisToString(calendar.getTimeInMillis()));
        }
        return stringSequence;
    }

    public String toString() {
        return String.format("StartTime : %s, EndTime : %s, Aggregated %s", TemporalConstraint.timeInMillisToString(this.startTime), TemporalConstraint.timeInMillisToString(this.endTime), this.aggregationMode.toString());
    }

    public static enum CalendarEnum {
        YEAR(1),
        MONTH(2),
        DAY(5),
        HOUR(11),
        MINUTE(12),
        SECOND(13),
        MILLISECOND(14);

        private final int calendarValue;

        private CalendarEnum(int calendarValue) {
            this.calendarValue = calendarValue;
        }

        public int getCalendarValue() {
            return this.calendarValue;
        }
    }

    public static enum AggregationMode {
        YEARLY,
        MONTHLY,
        DAILY,
        HOURLY,
        MINUTELY,
        SECONDLY,
        MILLISECONDLY;

    }
}

