/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.security.authn.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.gcube.accounting.security.SecurityManager;
import org.gcube.accounting.security.authz.Action;

public class DelegateFilter
implements Filter {
    private static Logger logger = Logger.getLogger(DelegateFilter.class);

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        if (!SecurityManager.isAuthnEnabled()) {
            logger.debug((Object)"Authentication is not enabled. Skipping.");
            chain.doFilter(req, res);
            return;
        }
        String delegatorId = request.getHeader("delegatorId");
        if (delegatorId == null || delegatorId.trim().equals("")) {
            logger.debug((Object)"No delegator id provided. Skipping.");
            chain.doFilter(req, res);
            return;
        }
        String userId = (String)request.getAttribute("userId");
        if (SecurityManager.isAuthzEnabled() && SecurityManager.getAuthorizationManager().isAllowed(userId, Action.ACT_AS_DELEGATE)) {
            logger.info((Object)String.format("Replacing userId with delegatorId: %s -> %s", userId, delegatorId));
            request.setAttribute("userId", (Object)delegatorId);
        } else {
            logger.debug((Object)(userId + " can't act as delegate. Skipping."));
        }
        chain.doFilter(req, res);
    }
}

