package org.gcube.accounting.datamodel.aggregation;

public class ResultOptions {

	private String sortField;
	private int sortOrder;
	private int startRecord;
	private int recordsPerPage;



	public ResultOptions() {
		super();
		this.setSortOrder("desc");
	}
	
	public ResultOptions(String sortField) {
		super();
		this.setSortField(sortField);
		this.setSortOrder("desc");
	}
	
	public ResultOptions(String sortField, int startRecord, int recordsPerPage) {
		super();
		this.setSortField(sortField);
		this.setSortOrder("desc");
		this.setStartRecord(startRecord);
		this.setRecordsPerPage(recordsPerPage);
	}


	public ResultOptions(String sortField, int sortOrder, int startRecord,
			int recordsPerPage) {
		super();
		this.sortField = sortField;
		this.sortOrder = sortOrder;
		this.startRecord = startRecord;
		this.recordsPerPage = recordsPerPage;
	}


	public String getSortField() {
		return sortField;
	}
	public void setSortField(String sortField) {
		this.sortField = sortField;
	}
	public int getSortOrder() {
		return sortOrder;
	}
	public void setSortOrder(String sortOrder) {
		if("desc".equalsIgnoreCase(sortOrder))
			this.sortOrder = -1;
		else
			this.sortOrder = 1;
	}
	public int getStartRecord() {
		return startRecord;
	}
	public void setStartRecord(int startRecord) {
		this.startRecord = startRecord;
	}
	public int getRecordsPerPage() {
		return recordsPerPage;
	}
	public void setRecordsPerPage(int recordsPerPage) {
		this.recordsPerPage = recordsPerPage;
	}


}
