/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataharvest.harvester.sobigdata;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.gcube.accounting.accounting.summary.access.model.ScopeDescriptor;
import org.gcube.accounting.accounting.summary.access.model.internal.Dimension;
import org.gcube.accounting.accounting.summary.access.model.update.AccountingRecord;
import org.gcube.dataharvest.AccountingDataHarvesterPlugin;
import org.gcube.dataharvest.datamodel.HarvestedDataKey;
import org.gcube.dataharvest.harvester.sobigdata.SoBigDataHarvester;
import org.gcube.dataharvest.utils.DateUtils;
import org.gcube.dataharvest.utils.Utils;
import org.gcube.portlets.user.urlshortener.UrlEncoderUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceCatalogueHarvester
extends SoBigDataHarvester {
    private static final String AND = " AND ";
    public static int ROWS = 500;
    private static Logger logger = LoggerFactory.getLogger(ResourceCatalogueHarvester.class);
    protected String solrBaseUrl;

    public ResourceCatalogueHarvester(Date start, Date end, SortedSet<String> contexts) throws Exception {
        super(start, end, contexts);
    }

    protected String getSolrBaseUrl() {
        return "https://ckan-solr-d4s.d4science.org/solr/sobigdata";
    }

    @Override
    public List<AccountingRecord> getAccountingRecords() throws Exception {
        ArrayList<AccountingRecord> accountingRecords = new ArrayList<AccountingRecord>();
        for (String systemType : this.mapSystemTypeToDBEntry.keySet()) {
            ArrayList<String> solrParameters = new ArrayList<String>(1);
            solrParameters.add("extras_systemtype:\"" + systemType + "\"");
            String queryResult = this.executeQueryFor(solrParameters, this.start, this.end, "groups");
            HarvestedDataKey insertDBKey = HarvestedDataKey.valueOf((String)this.mapSystemTypeToDBEntry.get(systemType));
            logger.debug("Creating statistics for type {} using db key {}", (Object)systemType, (Object)insertDBKey);
            accountingRecords.addAll(this.buildListOfHarvestedData(queryResult, insertDBKey));
        }
        return accountingRecords;
    }

    private List<AccountingRecord> buildListOfHarvestedData(String json, HarvestedDataKey harvestKey) throws Exception {
        JSONObject jsonObject = new JSONObject(json);
        JSONObject responseHeader = jsonObject.getJSONObject("responseHeader");
        int status = responseHeader.getInt("status");
        if (status != 0) {
            throw new Exception("Query Deliverable in error: status " + status);
        }
        JSONObject response = jsonObject.getJSONObject("response");
        int numFound = response.getInt("numFound");
        HashMap<String, Integer> counter = new HashMap<String, Integer>(this.mapCatalogueGroupToVRE.size() + 1);
        for (String groupName : this.mapCatalogueGroupToVRE.keySet()) {
            counter.put(groupName, 0);
        }
        String catalogueContext = Utils.getCurrentContext();
        int catalogueContextCount = 0;
        logger.debug("For {}  has found {} doc/s", (Object)harvestKey, (Object)numFound);
        if (numFound > 0) {
            JSONArray docs = response.getJSONArray("docs");
            for (Object item : docs) {
                JSONObject doc = (JSONObject)item;
                try {
                    JSONArray groups = doc.getJSONArray("groups");
                    Iterator git = groups.iterator();
                    if (!git.hasNext()) continue;
                    String catalogueGroupName = (String)git.next();
                    logger.debug("GroupName found {}", (Object)catalogueGroupName);
                    Integer currentCount = (Integer)counter.get(catalogueGroupName);
                    if (currentCount != null) {
                        counter.put(catalogueGroupName, currentCount + 1);
                        continue;
                    }
                    logger.warn("No mapping found for Catalogue-Group Name {} from VREs. Accounting it in the catalogue context {}", (Object)catalogueGroupName, (Object)catalogueContext);
                    ++catalogueContextCount;
                }
                catch (JSONException x) {
                    logger.debug("Document without groups, accounting it in the catalogue context");
                    ++catalogueContextCount;
                }
                catch (Exception e) {
                    logger.warn("Skipping parsing error", (Throwable)e);
                }
            }
        }
        ArrayList<AccountingRecord> accountingRecords = new ArrayList<AccountingRecord>();
        logger.trace("The context {} has count ", (Object)catalogueContext, (Object)catalogueContextCount);
        ScopeDescriptor catalogueScopeDescriptor = AccountingDataHarvesterPlugin.getScopeDescriptor(catalogueContext);
        Dimension dimension = this.getDimension(harvestKey);
        AccountingRecord ar = new AccountingRecord(catalogueScopeDescriptor, this.instant, dimension, Long.valueOf(catalogueContextCount));
        accountingRecords.add(ar);
        for (String key : counter.keySet()) {
            logger.trace("The group {} has count {}", (Object)key, counter.get(key));
            ScopeDescriptor sd = AccountingDataHarvesterPlugin.getScopeDescriptor((String)this.mapCatalogueGroupToVRE.get(key));
            AccountingRecord accountingRecord = new AccountingRecord(sd, this.instant, dimension, Long.valueOf(((Integer)counter.get(key)).intValue()));
            accountingRecords.add(accountingRecord);
        }
        logger.debug("For {} in the period [from {} to {}] returning accouting data :", new Object[]{harvestKey, DateUtils.format(this.start), DateUtils.format(this.end), accountingRecords});
        return accountingRecords;
    }

    public String executeQueryFor(List<String> solrParameters, Date startDate, Date endDate, String flValue) throws Exception {
        String query = this.getSolrBaseUrl().endsWith("/") ? this.getSolrBaseUrl() : this.getSolrBaseUrl() + "/";
        query = query + "select?";
        String q = "";
        if (startDate != null && endDate != null) {
            q = q + "metadata_created:[" + DateUtils.dateToStringWithTZ(startDate) + " TO " + DateUtils.dateToStringWithTZ(endDate) + "]";
        }
        if (solrParameters != null && solrParameters.size() > 0) {
            q = q + (q.isEmpty() ? "" : AND);
            for (int i = 0; i < solrParameters.size() - 1; ++i) {
                q = q + solrParameters.get(i) + AND;
            }
            q = q + solrParameters.get(solrParameters.size() - 1);
        }
        query = query + "q=" + UrlEncoderUtil.encodeQuery((String[])new String[]{q}) + "&wt=json&indent=true&rows=" + ROWS;
        query = query + (flValue != null && !flValue.isEmpty() ? "&fl=" + UrlEncoderUtil.encodeQuery((String[])new String[]{flValue}) : "");
        logger.debug("\nPerforming query {}", (Object)query);
        String jsonResult = Utils.getJson(query);
        logger.trace("Response is {}", (Object)jsonResult);
        return jsonResult;
    }
}

