/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.kv.subdoc.simple;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.kv.subdoc.simple.AbstractSubdocMutationRequest;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;

@InterfaceStability.Committed
@InterfaceAudience.Public
public class SubCounterRequest
extends AbstractSubdocMutationRequest {
    public SubCounterRequest(String key, String path, long delta, String bucket, int expiration, long cas) {
        super(key, path, SubCounterRequest.deltaToFragment(delta), bucket, expiration, cas);
        if (path.isEmpty()) {
            this.cleanUpAndThrow(EXCEPTION_EMPTY_PATH);
        }
    }

    public SubCounterRequest(String key, String path, long delta, String bucket) {
        this(key, path, delta, bucket, 0, 0L);
    }

    private static ByteBuf deltaToFragment(long delta) {
        String sDelta = "" + delta;
        return Unpooled.copiedBuffer(sDelta, CharsetUtil.UTF_8);
    }

    @Override
    public byte opcode() {
        return -49;
    }
}

