/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.storagehub.client.proxies;

import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MultivaluedHashMap;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.gxrest.request.GXWebTargetAdapterRequest;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.gcube.common.storagehub.client.proxies.GroupManagerClient;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;

public class DefaultGroupManager
implements GroupManagerClient {
    private final ProxyDelegate<GXWebTargetAdapterRequest> delegate;

    public DefaultGroupManager(ProxyDelegate<GXWebTargetAdapterRequest> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void addUserToGroup(final String userId, final String groupId) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Void> call = new Call<GXWebTargetAdapterRequest, Void>(){

            public Void call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager;
                MultivaluedHashMap formData = new MultivaluedHashMap();
                formData.add((Object)"userId", (Object)userId);
                GXInboundResponse response = myManager.path(groupId).put(Entity.entity((Object)formData, (String)"application/x-www-form-urlencoded"));
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError();
                }
                return null;
            }
        };
        try {
            this.delegate.make((Call)call);
            return;
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public void removeUserFromGroup(final String userId, final String groupId) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Void> call = new Call<GXWebTargetAdapterRequest, Void>(){

            public Void call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager;
                GXInboundResponse response = myManager.path(groupId).path("users").path(userId).delete();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError();
                }
                return null;
            }
        };
        try {
            this.delegate.make((Call)call);
            return;
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public List<String> getGroups() throws StorageHubException {
        Call<GXWebTargetAdapterRequest, List<String>> call = new Call<GXWebTargetAdapterRequest, List<String>>(){

            public List<String> call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager;
                GXInboundResponse response = myManager.get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError();
                }
                return (List)response.getSource().readEntity(List.class);
            }
        };
        try {
            List users = (List)this.delegate.make((Call)call);
            return users;
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public void removeGroup(final String groupId) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Void> call = new Call<GXWebTargetAdapterRequest, Void>(){

            public Void call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager;
                GXInboundResponse response = myManager.path(groupId).delete();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError();
                }
                return null;
            }
        };
        try {
            this.delegate.make((Call)call);
            return;
        }
        catch (StorageHubException e) {
            throw e;
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public void createGroup(final String groupId, final AccessType accessType) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, Void> call = new Call<GXWebTargetAdapterRequest, Void>(){

            public Void call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager;
                MultivaluedHashMap formData = new MultivaluedHashMap();
                formData.add((Object)"group", (Object)groupId);
                formData.add((Object)"accessType", (Object)accessType);
                GXInboundResponse response = myManager.post(Entity.entity((Object)formData, (String)"application/x-www-form-urlencoded"));
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError();
                }
                return null;
            }
        };
        try {
            this.delegate.make((Call)call);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> getUsersOfGroup(final String groupId) throws StorageHubException {
        Call<GXWebTargetAdapterRequest, List<String>> call = new Call<GXWebTargetAdapterRequest, List<String>>(){

            public List<String> call(GXWebTargetAdapterRequest manager) throws Exception {
                GXWebTargetAdapterRequest myManager = manager;
                GXInboundResponse response = myManager.path(groupId).path("users").get();
                if (response.isErrorResponse()) {
                    if (response.hasException()) {
                        throw response.getException();
                    }
                    throw new BackendGenericError();
                }
                return (List)response.getSource().readEntity(List.class);
            }
        };
        try {
            List users = (List)this.delegate.make((Call)call);
            return users;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

