/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.repository.mapping;

import com.couchbase.client.java.repository.mapping.EntityMetadata;
import com.couchbase.client.java.repository.mapping.PropertyMetadata;
import com.couchbase.client.java.repository.mapping.ReflectionBasedPropertyMetadata;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReflectionBasedEntityMetadata
implements EntityMetadata {
    private final List<PropertyMetadata> properties = new ArrayList<PropertyMetadata>();
    private final PropertyMetadata idProperty;

    public ReflectionBasedEntityMetadata(Class<?> sourceEntity) {
        ReflectionBasedPropertyMetadata idProperty = null;
        for (Field field : ReflectionBasedEntityMetadata.getAllDeclaredFields(sourceEntity)) {
            ReflectionBasedPropertyMetadata property = new ReflectionBasedPropertyMetadata(field);
            this.properties.add(property);
            if (!property.isId()) continue;
            idProperty = property;
        }
        this.idProperty = idProperty;
    }

    private static List<Field> getAllDeclaredFields(Class<?> sourceEntity) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz = sourceEntity; clazz != null; clazz = clazz.getSuperclass()) {
            Field[] f = clazz.getDeclaredFields();
            fields.addAll(Arrays.asList(f));
        }
        return fields;
    }

    @Override
    public List<PropertyMetadata> properties() {
        return this.properties;
    }

    @Override
    public boolean hasIdProperty() {
        return this.idProperty != null;
    }

    @Override
    public PropertyMetadata idProperty() {
        return this.idProperty;
    }
}

