/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.bucket.api;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.analytics.AnalyticsRequest;
import com.couchbase.client.core.message.config.ConfigRequest;
import com.couchbase.client.core.message.kv.BinaryRequest;
import com.couchbase.client.core.message.query.QueryRequest;
import com.couchbase.client.core.message.search.SearchRequest;
import com.couchbase.client.core.message.view.ViewRequest;
import com.couchbase.client.core.utils.DefaultObjectMapper;
import com.couchbase.client.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import io.opentracing.Scope;
import io.opentracing.Span;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import rx.Observable;
import rx.functions.Func1;

@InterfaceAudience.Private
@InterfaceStability.Uncommitted
public class Utils {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(Utils.class);

    @InterfaceAudience.Private
    @InterfaceStability.Uncommitted
    public static <X extends CouchbaseException, R extends CouchbaseResponse> X addDetails(X ex, R r) {
        if (r.statusDetails() != null) {
            ex.details(r.statusDetails());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{} returned with enhanced error details {}", r, ex);
            }
        }
        return ex;
    }

    static String formatTimeout(CouchbaseRequest request, long timeout) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldMap.put("t", timeout);
        if (request != null) {
            fieldMap.put("s", Utils.formatServiceType(request));
            Utils.putIfNotNull(fieldMap, "i", request.operationId());
            Utils.putIfNotNull(fieldMap, "b", request.bucket());
            Utils.putIfNotNull(fieldMap, "c", request.lastLocalId());
            Utils.putIfNotNull(fieldMap, "l", request.lastLocalSocket());
            Utils.putIfNotNull(fieldMap, "r", request.lastRemoteSocket());
        }
        try {
            return DefaultObjectMapper.writeValueAsString(fieldMap);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Could not format timeout information for request " + request, (Throwable)e);
            return null;
        }
    }

    private static void putIfNotNull(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    private static String formatServiceType(CouchbaseRequest request) {
        if (request instanceof BinaryRequest) {
            return "kv";
        }
        if (request instanceof QueryRequest) {
            return "n1ql";
        }
        if (request instanceof ViewRequest) {
            return "view";
        }
        if (request instanceof AnalyticsRequest) {
            return "analytics";
        }
        if (request instanceof SearchRequest) {
            return "search";
        }
        if (request instanceof ConfigRequest) {
            return "config";
        }
        return "unknown";
    }

    public static <T> Observable<T> applyTimeout(Observable<T> input, final CouchbaseRequest request, CouchbaseEnvironment environment, final long timeout, final TimeUnit timeUnit) {
        if (timeout > 0L) {
            return input.timeout(timeout, timeUnit, environment.scheduler()).onErrorResumeNext(new Func1<Throwable, Observable<? extends T>>(){

                public Observable<? extends T> call(Throwable t) {
                    if (t instanceof TimeoutException) {
                        return Observable.error((Throwable)new TimeoutException(Utils.formatTimeout(request, timeUnit.toMicros(timeout))));
                    }
                    return Observable.error((Throwable)t);
                }
            });
        }
        return input;
    }

    public static void addRequestSpan(CouchbaseEnvironment env, CouchbaseRequest request, String opName) {
        if (env.operationTracingEnabled()) {
            Span potentialParent;
            if (env.propagateParentSpan() && (potentialParent = env.tracer().activeSpan()) != null) {
                Utils.addRequestSpanWithParent(env, potentialParent, request, opName);
                return;
            }
            Scope scope = env.tracer().buildSpan(opName).startActive(false);
            request.span(scope.span(), (CoreEnvironment)env);
            scope.close();
        }
    }

    public static void addRequestSpanWithParent(CouchbaseEnvironment env, Span parent, CouchbaseRequest request, String opName) {
        if (env.operationTracingEnabled()) {
            Scope scope = env.tracer().buildSpan(opName).asChildOf(parent).startActive(false);
            request.span(scope.span(), (CoreEnvironment)env);
            scope.close();
        }
    }
}

