/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query.dsl.functions;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.query.dsl.Expression;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class PatternMatchingFunctions {
    private PatternMatchingFunctions() {
    }

    public static Expression regexpContains(Expression expression, String pattern) {
        return Expression.x("REGEXP_CONTAINS(" + expression.toString() + ", \"" + pattern + "\")");
    }

    public static Expression regexpContains(String expression, String pattern) {
        return PatternMatchingFunctions.regexpContains(Expression.x(expression), pattern);
    }

    public static Expression regexpLike(Expression expression, String pattern) {
        return Expression.x("REGEXP_LIKE(" + expression.toString() + ", \"" + pattern + "\")");
    }

    public static Expression regexpLike(String expression, String pattern) {
        return PatternMatchingFunctions.regexpLike(Expression.x(expression), pattern);
    }

    public static Expression regexpPosition(Expression expression, String pattern) {
        return Expression.x("REGEXP_POSITION(" + expression.toString() + ", \"" + pattern + "\")");
    }

    public static Expression regexpPosition(String expression, String pattern) {
        return PatternMatchingFunctions.regexpPosition(Expression.x(expression), pattern);
    }

    public static Expression regexpReplace(Expression expression, String pattern, String repl, int n) {
        return Expression.x("REGEXP_REPLACE(" + expression.toString() + ", \"" + pattern + "\", \"" + repl + "\", " + n + ")");
    }

    public static Expression regexpReplace(String expression, String pattern, String repl, int n) {
        return PatternMatchingFunctions.regexpReplace(Expression.x(expression), pattern, repl, n);
    }

    public static Expression regexpReplace(Expression expression, String pattern, String repl) {
        return Expression.x("REGEXP_REPLACE(" + expression.toString() + ", \"" + pattern + "\", \"" + repl + "\")");
    }

    public static Expression regexpReplace(String expression, String pattern, String repl) {
        return PatternMatchingFunctions.regexpReplace(Expression.x(expression), pattern, repl);
    }
}

