/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.ResponseHandler;
import com.couchbase.client.core.endpoint.BootstrapAdapter;
import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.endpoint.SSLEngineFactory;
import com.couchbase.client.core.endpoint.kv.AuthenticationException;
import com.couchbase.client.core.endpoint.util.FailedChannel;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.internal.EndpointHealth;
import com.couchbase.client.core.message.internal.SignalConfigReload;
import com.couchbase.client.core.message.internal.SignalFlush;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.state.AbstractStateMachine;
import com.couchbase.client.core.state.LifecycleState;
import com.couchbase.client.core.state.NotConnectedException;
import com.couchbase.client.core.utils.NetworkAddress;
import com.couchbase.client.core.utils.Observables;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import com.couchbase.client.deps.io.netty.bootstrap.Bootstrap;
import com.couchbase.client.deps.io.netty.buffer.AbstractByteBufAllocator;
import com.couchbase.client.deps.io.netty.buffer.PooledByteBufAllocator;
import com.couchbase.client.deps.io.netty.buffer.UnpooledByteBufAllocator;
import com.couchbase.client.deps.io.netty.channel.Channel;
import com.couchbase.client.deps.io.netty.channel.ChannelFuture;
import com.couchbase.client.deps.io.netty.channel.ChannelFutureListener;
import com.couchbase.client.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.deps.io.netty.channel.ChannelInitializer;
import com.couchbase.client.deps.io.netty.channel.ChannelOption;
import com.couchbase.client.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.deps.io.netty.channel.ConnectTimeoutException;
import com.couchbase.client.deps.io.netty.channel.DefaultChannelPromise;
import com.couchbase.client.deps.io.netty.channel.EventLoopGroup;
import com.couchbase.client.deps.io.netty.channel.epoll.EpollEventLoopGroup;
import com.couchbase.client.deps.io.netty.channel.epoll.EpollSocketChannel;
import com.couchbase.client.deps.io.netty.channel.oio.OioEventLoopGroup;
import com.couchbase.client.deps.io.netty.channel.socket.nio.NioSocketChannel;
import com.couchbase.client.deps.io.netty.channel.socket.oio.OioSocketChannel;
import com.couchbase.client.deps.io.netty.handler.logging.LogLevel;
import com.couchbase.client.deps.io.netty.handler.logging.LoggingHandler;
import com.couchbase.client.deps.io.netty.handler.ssl.SslHandler;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLHandshakeException;
import rx.Observable;
import rx.Single;
import rx.SingleSubscriber;
import rx.Subscriber;
import rx.functions.Func1;
import rx.subjects.AsyncSubject;
import rx.subjects.Subject;

public abstract class AbstractEndpoint
extends AbstractStateMachine<LifecycleState>
implements Endpoint {
    protected static final boolean FORCE_DNS_LOOKUP_ON_RECONNECT = Boolean.parseBoolean(System.getProperty("com.couchbase.forceDnsLookupOnReconnect", "false"));
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(Endpoint.class);
    private static final ChannelHandler LOGGING_HANDLER_INSTANCE = new LoggingHandler(LogLevel.TRACE);
    private static final NotConnectedException NOT_CONNECTED_EXCEPTION = new NotConnectedException();
    private static final String DEFAULT_CONNECT_CALLBACK_GRACE_PERIOD = "2000";
    private volatile BootstrapAdapter bootstrap;
    private final String bucket;
    private final String username;
    private final String password;
    private final RingBuffer<ResponseEvent> responseBuffer;
    private final CoreEnvironment env;
    private final CoreContext ctx;
    private final boolean isTransient;
    private final int connectCallbackGracePeriod;
    private final EventLoopGroup ioPool;
    private final boolean pipeline;
    private final String hostname;
    private final int port;
    private final SSLEngineFactory sslEngineFactory;
    private volatile Channel channel;
    private volatile boolean hasWritten;
    private volatile long reconnectAttempt = 1L;
    private volatile boolean disconnected;
    private volatile boolean free;
    private volatile long lastResponse;
    private volatile long lastKeepAliveLatency;

    protected AbstractEndpoint(String bucket, String username, String password, BootstrapAdapter adapter, boolean isTransient, CoreContext ctx, boolean pipeline) {
        super(LifecycleState.DISCONNECTED);
        this.bootstrap = adapter;
        this.bucket = bucket;
        this.username = username;
        this.password = password;
        this.responseBuffer = null;
        this.env = ctx.environment();
        this.ctx = ctx;
        this.isTransient = isTransient;
        this.disconnected = false;
        this.pipeline = pipeline;
        this.connectCallbackGracePeriod = Integer.parseInt(DEFAULT_CONNECT_CALLBACK_GRACE_PERIOD);
        this.ioPool = this.env.ioPool();
        this.lastResponse = 0L;
        this.free = true;
        this.hostname = "127.0.0.1";
        this.port = 0;
        this.sslEngineFactory = null;
    }

    protected AbstractEndpoint(String hostname, String bucket, String username, String password, int port, CoreContext ctx, boolean isTransient, EventLoopGroup ioPool, boolean pipeline) {
        super(LifecycleState.DISCONNECTED);
        this.bucket = bucket;
        this.username = username;
        this.password = password;
        this.responseBuffer = ctx.responseRingBuffer();
        this.env = ctx.environment();
        this.ctx = ctx;
        this.isTransient = isTransient;
        this.ioPool = ioPool;
        this.pipeline = pipeline;
        this.free = true;
        this.hostname = hostname;
        this.port = port;
        this.connectCallbackGracePeriod = Integer.parseInt(System.getProperty("com.couchbase.connectCallbackGracePeriod", DEFAULT_CONNECT_CALLBACK_GRACE_PERIOD));
        LOGGER.debug("Using a connectCallbackGracePeriod of {} on Endpoint {}:{}", this.connectCallbackGracePeriod, hostname, port);
        this.sslEngineFactory = this.env.sslEnabled() ? new SSLEngineFactory(this.env) : null;
        this.bootstrap = this.createBootstrap(hostname, port);
    }

    private BootstrapAdapter createBootstrap(String hostname, int port) {
        Class channelClass = NioSocketChannel.class;
        if (this.ioPool instanceof EpollEventLoopGroup) {
            channelClass = EpollSocketChannel.class;
        } else if (this.ioPool instanceof OioEventLoopGroup) {
            channelClass = OioSocketChannel.class;
        }
        if (NetworkAddress.FORCE_IPV4) {
            hostname = NetworkAddress.create(hostname).nameOrAddress();
        }
        AbstractByteBufAllocator allocator = this.env.bufferPoolingEnabled() ? PooledByteBufAllocator.DEFAULT : UnpooledByteBufAllocator.DEFAULT;
        boolean tcpNodelay = this.environment().tcpNodelayEnabled();
        return new BootstrapAdapter((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().remoteAddress(hostname, port).group(this.ioPool)).channel(channelClass)).option(ChannelOption.ALLOCATOR, allocator)).option(ChannelOption.TCP_NODELAY, tcpNodelay)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.env.socketConnectTimeout())).handler(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                if (AbstractEndpoint.this.env.sslEnabled()) {
                    pipeline.addLast(new SslHandler(AbstractEndpoint.this.sslEngineFactory.get()));
                }
                if (LOGGER.isTraceEnabled()) {
                    pipeline.addLast(LOGGING_HANDLER_INSTANCE);
                }
                AbstractEndpoint.this.customEndpointHandlers(pipeline);
            }
        }));
    }

    protected abstract void customEndpointHandlers(ChannelPipeline var1);

    @Override
    public Observable<LifecycleState> connect() {
        return this.connect(true);
    }

    protected Observable<LifecycleState> connect(boolean bootstrapping) {
        if (this.state() != LifecycleState.DISCONNECTED) {
            return Observable.just(this.state());
        }
        AsyncSubject observable = AsyncSubject.create();
        this.transitionState(LifecycleState.CONNECTING);
        this.hasWritten = false;
        this.doConnect((Subject<LifecycleState, LifecycleState>)observable, bootstrapping);
        return observable;
    }

    protected void doConnect(final Subject<LifecycleState, LifecycleState> observable, final boolean bootstrapping) {
        Single.create((Single.OnSubscribe)new Single.OnSubscribe<ChannelFuture>(){

            public void call(final SingleSubscriber<? super ChannelFuture> ss) {
                AbstractEndpoint.this.bootstrap.connect().addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture cf) throws Exception {
                        if (ss.isUnsubscribed()) {
                            if (cf.isSuccess() && cf.channel() != null) {
                                cf.channel().close().addListener(new ChannelFutureListener(){

                                    @Override
                                    public void operationComplete(ChannelFuture future) throws Exception {
                                        if (!future.isSuccess()) {
                                            LOGGER.debug("Got exception while disconnecting stray connect attempt.", future.cause());
                                        }
                                    }
                                });
                            }
                        } else {
                            ss.onSuccess((Object)cf);
                        }
                    }
                });
            }
        }).timeout((long)(this.env.socketConnectTimeout() + this.connectCallbackGracePeriod), TimeUnit.MILLISECONDS).onErrorResumeNext((Func1)new Func1<Throwable, Single<? extends ChannelFuture>>(){

            public Single<? extends ChannelFuture> call(Throwable throwable) {
                DefaultChannelPromise promise = new DefaultChannelPromise(new FailedChannel(), AbstractEndpoint.this.ioPool.next());
                if (throwable instanceof TimeoutException) {
                    promise.setFailure(new ConnectTimeoutException("Connect callback did not return, hit safeguarding timeout."));
                } else {
                    promise.setFailure(throwable);
                }
                return Single.just((Object)promise);
            }
        }).subscribe((SingleSubscriber)new SingleSubscriber<ChannelFuture>(){

            public void onSuccess(ChannelFuture future) {
                if (AbstractEndpoint.this.disconnected) {
                    LOGGER.debug(AbstractEndpoint.logIdent(AbstractEndpoint.this.channel, AbstractEndpoint.this) + "Endpoint connect completed, but got instructed to disconnect in the meantime.");
                    AbstractEndpoint.this.transitionState(LifecycleState.DISCONNECTED);
                    AbstractEndpoint.this.channel = null;
                } else if (future.isSuccess()) {
                    AbstractEndpoint.this.channel = future.channel();
                    LOGGER.debug(AbstractEndpoint.logIdent(AbstractEndpoint.this.channel, AbstractEndpoint.this) + "Connected Endpoint.");
                    AbstractEndpoint.this.transitionState(LifecycleState.CONNECTED);
                } else {
                    if (future.cause() instanceof AuthenticationException) {
                        LOGGER.warn("{}Authentication Failure: {}", (Object)AbstractEndpoint.logIdent(AbstractEndpoint.this.channel, AbstractEndpoint.this), (Object)future.cause().getMessage());
                        AbstractEndpoint.this.transitionState(LifecycleState.DISCONNECTED);
                        observable.onError(future.cause());
                    } else if (future.cause() instanceof SSLHandshakeException) {
                        LOGGER.warn("{}SSL Handshake Failure during connect: {}", (Object)AbstractEndpoint.logIdent(AbstractEndpoint.this.channel, AbstractEndpoint.this), (Object)future.cause().getMessage());
                        AbstractEndpoint.this.transitionState(LifecycleState.DISCONNECTED);
                        observable.onError(future.cause());
                    } else if (future.cause() instanceof ClosedChannelException) {
                        LOGGER.warn("{}Generic Failure: {}", (Object)AbstractEndpoint.logIdent(AbstractEndpoint.this.channel, AbstractEndpoint.this), (Object)future.cause().getMessage());
                        AbstractEndpoint.this.transitionState(LifecycleState.DISCONNECTED);
                        LOGGER.warn(future.cause().getMessage());
                        observable.onError(future.cause());
                    } else if (future.cause() instanceof ConnectTimeoutException) {
                        LOGGER.warn("{}Socket connect took longer than specified timeout: {}", (Object)AbstractEndpoint.logIdent(AbstractEndpoint.this.channel, AbstractEndpoint.this), (Object)future.cause().getMessage());
                        AbstractEndpoint.this.transitionState(LifecycleState.DISCONNECTED);
                        observable.onError(future.cause());
                    } else if (future.cause() instanceof ConnectException) {
                        LOGGER.warn("{}Could not connect to remote socket: {}", (Object)AbstractEndpoint.logIdent(AbstractEndpoint.this.channel, AbstractEndpoint.this), (Object)future.cause().getMessage());
                        AbstractEndpoint.this.transitionState(LifecycleState.DISCONNECTED);
                        observable.onError(future.cause());
                    } else if (AbstractEndpoint.this.isTransient) {
                        AbstractEndpoint.this.transitionState(LifecycleState.DISCONNECTED);
                        LOGGER.warn(future.cause().getMessage());
                        observable.onError(future.cause());
                    } else {
                        LOGGER.debug("Unhandled exception during channel connect, ignoring.", future.cause());
                    }
                    if (bootstrapping) {
                        AbstractEndpoint.this.connect(false).subscribe((Subscriber)new Subscriber<LifecycleState>(){

                            public void onCompleted() {
                            }

                            public void onNext(LifecycleState lifecycleState) {
                            }

                            public void onError(Throwable e) {
                                LOGGER.warn("Error during reconnect: {}", (Object)e.toString());
                            }
                        });
                    } else if (!AbstractEndpoint.this.disconnected && !AbstractEndpoint.this.isTransient) {
                        long delay = AbstractEndpoint.this.env.reconnectDelay().calculate(AbstractEndpoint.this.reconnectAttempt++);
                        TimeUnit delayUnit = AbstractEndpoint.this.env.reconnectDelay().unit();
                        String cause = future.cause() == null ? "unknown" : future.cause().toString();
                        LOGGER.warn("{}Could not connect to endpoint on reconnect attempt {}, retrying with delay " + delay + " " + (Object)((Object)delayUnit) + ": {}", AbstractEndpoint.logIdent(AbstractEndpoint.this.channel, AbstractEndpoint.this), AbstractEndpoint.this.reconnectAttempt, cause);
                        if (AbstractEndpoint.this.responseBuffer != null) {
                            AbstractEndpoint.this.responseBuffer.publishEvent(ResponseHandler.RESPONSE_TRANSLATOR, SignalConfigReload.INSTANCE, null);
                        }
                        AbstractEndpoint.this.transitionState(LifecycleState.CONNECTING);
                        AbstractEndpoint.this.ioPool.next().schedule(new Runnable(){

                            @Override
                            public void run() {
                                if (!AbstractEndpoint.this.disconnected) {
                                    if (FORCE_DNS_LOOKUP_ON_RECONNECT) {
                                        AbstractEndpoint.this.bootstrap = AbstractEndpoint.this.createBootstrap(AbstractEndpoint.this.hostname, AbstractEndpoint.this.port);
                                    }
                                    AbstractEndpoint.this.doConnect((Subject<LifecycleState, LifecycleState>)observable, bootstrapping);
                                } else {
                                    LOGGER.debug("{}Explicitly breaking retry loop because already disconnected.", (Object)AbstractEndpoint.logIdent(AbstractEndpoint.this.channel, AbstractEndpoint.this));
                                    AbstractEndpoint.this.disconnect();
                                }
                            }
                        }, delay, delayUnit);
                    } else {
                        LOGGER.debug("{}Not retrying because already disconnected or transient.", (Object)AbstractEndpoint.logIdent(AbstractEndpoint.this.channel, AbstractEndpoint.this));
                    }
                }
                observable.onNext(AbstractEndpoint.this.state());
                observable.onCompleted();
            }

            public void onError(Throwable error) {
                LOGGER.warn("Unexpected error on connect callback wrapper, this is a bug.", error);
            }
        });
    }

    @Override
    public Observable<LifecycleState> disconnect() {
        this.disconnected = true;
        if (this.state() == LifecycleState.DISCONNECTED || this.state() == LifecycleState.DISCONNECTING) {
            return Observable.just(this.state());
        }
        if (this.state() == LifecycleState.CONNECTING) {
            this.transitionState(LifecycleState.DISCONNECTED);
            return Observable.just(this.state());
        }
        this.transitionState(LifecycleState.DISCONNECTING);
        final AsyncSubject observable = AsyncSubject.create();
        this.channel.disconnect().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    LOGGER.debug(AbstractEndpoint.logIdent(AbstractEndpoint.this.channel, AbstractEndpoint.this) + "Disconnected Endpoint.");
                } else {
                    LOGGER.warn("{}Received an error during disconnect.", (Object)AbstractEndpoint.logIdent(AbstractEndpoint.this.channel, AbstractEndpoint.this), (Object)future.cause());
                }
                AbstractEndpoint.this.transitionState(LifecycleState.DISCONNECTED);
                observable.onNext(AbstractEndpoint.this.state());
                observable.onCompleted();
                AbstractEndpoint.this.channel = null;
            }
        });
        return observable;
    }

    @Override
    public void send(CouchbaseRequest request) {
        if (this.state() == LifecycleState.CONNECTED) {
            if (request instanceof SignalFlush) {
                if (this.hasWritten && this.channel.isActive()) {
                    this.channel.flush();
                    this.hasWritten = false;
                }
            } else if (this.channel.isActive() && this.channel.isWritable()) {
                if (!this.pipeline) {
                    this.free = false;
                }
                this.channel.write(request, this.channel.voidPromise());
                this.hasWritten = true;
            } else {
                this.responseBuffer.publishEvent(ResponseHandler.RESPONSE_TRANSLATOR, request, request.observable());
            }
        } else {
            if (request instanceof SignalFlush) {
                return;
            }
            Observables.failSafe(this.env.scheduler(), true, request.observable(), NOT_CONNECTED_EXCEPTION);
        }
    }

    public void notifyChannelInactive() {
        if (this.isTransient || this.disconnected) {
            return;
        }
        LOGGER.info("{}Got notified from Channel as inactive, attempting reconnect.", (Object)AbstractEndpoint.logIdent(this.channel, this));
        if (this.state() != LifecycleState.DISCONNECTED && this.state() != LifecycleState.DISCONNECTING) {
            this.signalConfigReload();
        }
        if (this.state() == LifecycleState.CONNECTED) {
            this.transitionState(LifecycleState.DISCONNECTED);
            this.connect(false).subscribe((Subscriber)new Subscriber<LifecycleState>(){

                public void onCompleted() {
                }

                public void onNext(LifecycleState lifecycleState) {
                }

                public void onError(Throwable e) {
                    LOGGER.warn("Error during reconnect: {}", (Object)e.toString());
                }
            });
        }
    }

    public void notifyResponseDecoded(boolean hidden) {
        this.free = true;
        if (!hidden) {
            this.lastResponse = System.nanoTime();
        }
    }

    public void setLastKeepAliveLatency(long latency) {
        this.lastKeepAliveLatency = latency;
    }

    @Override
    public long lastResponse() {
        return this.lastResponse;
    }

    public void signalConfigReload() {
        this.responseBuffer.publishEvent(ResponseHandler.RESPONSE_TRANSLATOR, SignalConfigReload.INSTANCE, null);
    }

    @Override
    public boolean isFree() {
        if (this.pipeline) {
            return true;
        }
        return this.free;
    }

    @Override
    public Single<EndpointHealth> diagnostics(ServiceType type) {
        LifecycleState currentState = (LifecycleState)((Object)this.state());
        SocketAddress remoteAddr = null;
        SocketAddress localAddr = null;
        if (this.channel != null) {
            remoteAddr = this.channel.remoteAddress();
            localAddr = this.channel.localAddress();
        }
        long lastActivity = TimeUnit.NANOSECONDS.toMicros(this.lastResponse > 0L ? System.nanoTime() - this.lastResponse : 0L);
        String id = "0x" + Integer.toHexString(this.hashCode());
        return Single.just((Object)new EndpointHealth(type, currentState, localAddr, remoteAddr, lastActivity, id));
    }

    protected String bucket() {
        return this.bucket;
    }

    protected String username() {
        return this.username;
    }

    protected String password() {
        return this.password;
    }

    public CoreEnvironment environment() {
        return this.env;
    }

    public CoreContext context() {
        return this.ctx;
    }

    public RingBuffer<ResponseEvent> responseBuffer() {
        return this.responseBuffer;
    }

    @Override
    public String remoteAddress() {
        return this.hostname + ":" + this.port;
    }

    protected static RedactableArgument logIdent(Channel chan, Endpoint endpoint) {
        String addr = chan != null ? chan.remoteAddress().toString() : endpoint.remoteAddress();
        return RedactableArgument.system("[" + addr + "][" + endpoint.getClass().getSimpleName() + "]: ");
    }

    static {
        NOT_CONNECTED_EXCEPTION.setStackTrace(new StackTraceElement[0]);
    }
}

