/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transcoder.subdoc;

import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.ByteBufOutputStream;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.subdoc.MultiValue;
import com.couchbase.client.java.transcoder.TranscoderUtils;
import com.couchbase.client.java.transcoder.subdoc.AbstractFragmentTranscoder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public abstract class AbstractByteArrayFragmentTranscoder
extends AbstractFragmentTranscoder {
    @Override
    public <T> T decodeWithMessage(ByteBuf encoded, Class<? extends T> clazz, String transcodingErrorMessage) throws TranscodingException {
        try {
            TranscoderUtils.ByteBufToArray toArray = TranscoderUtils.byteBufToByteArray(encoded);
            if (Object.class.equals(clazz)) {
                return (T)this.byteArrayToGenericObject(toArray.byteArray, toArray.offset, toArray.length);
            }
            return this.byteArrayToClass(toArray.byteArray, toArray.offset, toArray.length, clazz);
        }
        catch (Exception e) {
            throw new TranscodingException(transcodingErrorMessage, e);
        }
    }

    @Override
    protected <T> ByteBuf doEncodeSingle(T value, String transcodingErrorMessage) throws TranscodingException {
        try {
            return Unpooled.wrappedBuffer((byte[])this.writeValueAsBytes(value));
        }
        catch (Exception e) {
            throw new TranscodingException(transcodingErrorMessage, e);
        }
    }

    @Override
    protected ByteBuf doEncodeMulti(MultiValue<?> multiValue, String transcodingErrorMessage) throws TranscodingException {
        ByteBufOutputStream out = new ByteBufOutputStream(Unpooled.buffer((int)(4 * multiValue.size())));
        try {
            Iterator<?> iterator = multiValue.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                this.writeValueIntoStream((OutputStream)out, o);
                if (!iterator.hasNext()) continue;
                out.writeBytes(",");
            }
            return out.buffer();
        }
        catch (Exception e) {
            throw new TranscodingException(transcodingErrorMessage, e);
        }
    }

    protected abstract Object byteArrayToGenericObject(byte[] var1, int var2, int var3) throws IOException;

    protected abstract <T> T byteArrayToClass(byte[] var1, int var2, int var3, Class<? extends T> var4) throws IOException;

    protected abstract <T> byte[] writeValueAsBytes(T var1) throws IOException;

    protected abstract void writeValueIntoStream(OutputStream var1, Object var2) throws IOException;
}

