/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.accounting.summary.access.impl;

import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import lombok.NonNull;
import org.gcube.accounting.accounting.summary.access.model.MeasureResolution;
import org.gcube.accounting.accounting.summary.access.model.ScopeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Queries {
    private static final Logger log = LoggerFactory.getLogger(Queries.class);
    @NonNull
    private Connection conn;

    public long getMeasureCount(String table) throws SQLException {
        ResultSet rs = this.conn.createStatement().executeQuery("Select count(*) from " + table);
        rs.next();
        return rs.getLong(1);
    }

    public ResultSet listDimensions() throws SQLException {
        return this.conn.createStatement().executeQuery("Select * from dimensions order by LABEL");
    }

    public ResultSet listContexts() throws SQLException {
        return this.conn.createStatement().executeQuery("Select * from contexts order by LABEL");
    }

    public PreparedStatement getMeasureInsertionPreparedStatement() throws SQLException {
        String query = String.format("INSERT INTO %1$s (%2$s,%3$s,%4$s,%5$s) values (?,?,?,?) ON CONFLICT ON CONSTRAINT monthly_pKey DO UPDATE SET measure=?", "monthly", "context", "dimension", "time", "measure");
        return this.conn.prepareStatement(query);
    }

    public PreparedStatement getDimensionInsertionPreparedStatement() throws SQLException {
        String query = String.format("INSERT INTO %1$s (%2$s,%3$s,%4$s,%5$s) values (?,?,?,?)", "dimensions", "id", "LABEL", "dimension_group", "aggregated_measure");
        return this.conn.prepareStatement(query);
    }

    public PreparedStatement getContextInsertionPreparedStatement() throws SQLException {
        String query = String.format("INSERT INTO %1$s (%2$s,%3$s) values (?,?)", "contexts", "id", "LABEL");
        return this.conn.prepareStatement(query);
    }

    public ResultSet getAvailableDimensions(Instant from, Instant to, ScopeDescriptor scope, MeasureResolution resolution) throws SQLException {
        String query = String.format("Select * from %1$s where %2$s in (Select distinct(%3$s) from %4$s where %5$s AND %6$s)", "dimensions", "id", "dimension", "monthly", "true", "context IN " + Queries.asIDSet(scope));
        PreparedStatement toReturn = this.conn.prepareStatement(query);
        log.debug("Performing query {} ", (Object)query);
        return toReturn.executeQuery();
    }

    public PreparedStatement prepareMeasuresByDimension(ScopeDescriptor scope, MeasureResolution resolution) throws SQLException {
        return this.conn.prepareStatement(String.format("Select sum(%1$s) as %1$s,EXTRACT (MONTH FROM %6$s) as slice from %2$s where %3$s AND %4$s AND %5$s=? group by slice order by slice", "measure", "monthly", "context IN " + Queries.asIDSet(scope), String.format("EXTRACT(YEAR FROM %1$s) = EXTRACT(YEAR FROM CAST (? AS TIMESTAMP)) AND EXTRACT (MONTH FROM %1$s)= EXTRACT(MONTH FROM CAST (? AS TIMESTAMP)) ", "time"), "dimension", "time", "time"));
    }

    public static final String asIDSet(ScopeDescriptor desc) {
        return "(" + Queries.scopeList(desc) + ")";
    }

    private static final String scopeList(ScopeDescriptor desc) {
        StringBuilder setBuilder = new StringBuilder();
        setBuilder.append("'" + desc.getId() + "',");
        if (desc.hasChildren()) {
            for (ScopeDescriptor child : desc.getChildren()) {
                setBuilder.append(Queries.scopeList(child) + ",");
            }
        }
        String toReturn = setBuilder.toString();
        return toReturn.substring(0, toReturn.lastIndexOf(","));
    }

    @ConstructorProperties(value={"conn"})
    public Queries(@NonNull Connection conn) {
        if (conn == null) {
            throw new NullPointerException("conn");
        }
        this.conn = conn;
    }
}

