/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.gcat.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCatClientDiscovery {
    private static final Logger logger = LoggerFactory.getLogger(GCatClientDiscovery.class);
    protected static Map<String, URL> clients = new HashMap<String, URL>();
    private static String classFormat = "$resource/Profile/ServiceClass/text() eq '%1s'";
    private static String nameFormat = "$resource/Profile/ServiceName/text() eq '%1s'";
    private static String statusFormat = "$resource/Profile/DeploymentData/Status/text() eq 'ready'";
    private static String containsFormat = "$entry/@EntryName eq '%1s'";
    private static String serviceEndpointCategoryFormat = "$resource/Profile/Category/text() eq '%1s'";
    private static String serviceEndpointNameFormat = "$resource/Profile/Name/text() eq '%1s'";
    private static String serviceEndpointstatusFormat = "$resource/Profile/RunTime/Status/text() eq 'READY'";

    protected static void forceToURL(String adddress) throws MalformedURLException {
        if (adddress != null && adddress.compareTo("") != 0) {
            String context = GCatClientDiscovery.getContext();
            URL url = new URL(adddress);
            clients.put(context, url);
        }
    }

    private static SimpleQuery queryForService() {
        return ICFactory.queryFor(GCoreEndpoint.class).addCondition(String.format(classFormat, "DataPublishing")).addCondition(String.format(nameFormat, "gcat")).addCondition(String.format(statusFormat, new Object[0])).addVariable("$entry", "$resource/Profile/AccessPoint/RunningInstanceInterfaces/Endpoint").addCondition(String.format(containsFormat, "org.gcube.gcat.ResourceInitializer")).setResult("$entry/text()");
    }

    private static SimpleQuery queryForProxy() {
        return ICFactory.queryFor(ServiceEndpoint.class).addCondition(String.format(serviceEndpointCategoryFormat, "DataPublishing")).addCondition(String.format(serviceEndpointNameFormat, "gcat")).addCondition(String.format(serviceEndpointstatusFormat, new Object[0])).addVariable("$entry", "$resource/Profile/AccessPoint/Interface/Endpoint").addCondition(String.format(containsFormat, "org.gcube.gcat.ResourceInitializer")).setResult("$entry/text()");
    }

    protected static List<String> getAddresses() {
        List<String> addresses = new ArrayList();
        try {
            SimpleQuery proxyQuery = GCatClientDiscovery.queryForProxy();
            addresses = ICFactory.client().submit((Query)proxyQuery);
            if (addresses == null || addresses.isEmpty()) {
                throw new Exception("No ResourceRegistry Proxy Found");
            }
        }
        catch (Exception e) {
            logger.debug("{}. Looking for RunningInstance.", (Object)e.getMessage());
            SimpleQuery serviceQuery = GCatClientDiscovery.queryForService();
            addresses = ICFactory.client().submit((Query)serviceQuery);
        }
        return addresses;
    }

    protected static String getContext() {
        String context = null;
        if (SecurityTokenProvider.instance.get() == null) {
            if (ScopeProvider.instance.get() == null) {
                throw new RuntimeException("Null Token and Scope. Please set your token first.");
            }
            context = ScopeProvider.instance.get();
        } else {
            context = SecurityTokenProvider.instance.get();
        }
        return context;
    }

    public static URL getServiceURL() throws MalformedURLException {
        String context = GCatClientDiscovery.getContext();
        URL url = clients.get(context);
        if (url == null) {
            List<String> addresses = GCatClientDiscovery.getAddresses();
            if (addresses == null || addresses.isEmpty()) {
                String error = String.format("No %s:%s found in the current context", "DataPublishing", "gcat");
                throw new RuntimeException(error);
            }
            Random random = new Random();
            int index = random.nextInt(addresses.size());
            url = new URL(addresses.get(index));
            clients.put(context, url);
        }
        return url;
    }
}

