/*
 * Decompiled with CFR 0.152.
 */
package lombok.core.configuration;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.core.configuration.ConfigurationKey;
import lombok.core.configuration.ConfigurationValueParser;
import lombok.core.configuration.ExampleValueString;
import lombok.core.configuration.TypeName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationDataType {
    private static final Map<Class<?>, ConfigurationValueParser> SIMPLE_TYPES;
    private final boolean isList;
    private final ConfigurationValueParser parser;

    private static ConfigurationValueParser enumParser(Object enumType) {
        Class type;
        final Class rawType = type = (Class)enumType;
        return new ConfigurationValueParser(){

            public Object parse(String value) {
                try {
                    return Enum.valueOf(rawType, value);
                }
                catch (Exception e) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < value.length(); ++i) {
                        char c = value.charAt(i);
                        if (Character.isUpperCase(c) && i > 0) {
                            sb.append("_");
                        }
                        sb.append(Character.toUpperCase(c));
                    }
                    return Enum.valueOf(rawType, sb.toString());
                }
            }

            public String description() {
                return "enum (" + type.getName() + ")";
            }

            public String exampleValue() {
                ExampleValueString evs = type.getAnnotation(ExampleValueString.class);
                if (evs != null) {
                    return evs.value();
                }
                return Arrays.toString(type.getEnumConstants()).replace(",", " |");
            }
        };
    }

    public static ConfigurationDataType toDataType(Class<? extends ConfigurationKey<?>> keyClass) {
        ParameterizedType parameterizedArgument;
        if (keyClass.getSuperclass() != ConfigurationKey.class) {
            throw new IllegalArgumentException("No direct subclass of ConfigurationKey: " + keyClass.getName());
        }
        Type type = keyClass.getGenericSuperclass();
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Missing type parameter in " + type);
        }
        ParameterizedType parameterized = (ParameterizedType)type;
        Type argumentType = parameterized.getActualTypeArguments()[0];
        boolean isList = false;
        if (argumentType instanceof ParameterizedType && (parameterizedArgument = (ParameterizedType)argumentType).getRawType() == List.class) {
            isList = true;
            argumentType = parameterizedArgument.getActualTypeArguments()[0];
        }
        if (SIMPLE_TYPES.containsKey(argumentType)) {
            return new ConfigurationDataType(isList, SIMPLE_TYPES.get(argumentType));
        }
        if (ConfigurationDataType.isEnum(argumentType)) {
            return new ConfigurationDataType(isList, ConfigurationDataType.enumParser(argumentType));
        }
        throw new IllegalArgumentException("Unsupported type parameter in " + type);
    }

    private ConfigurationDataType(boolean isList, ConfigurationValueParser parser) {
        this.isList = isList;
        this.parser = parser;
    }

    public boolean isList() {
        return this.isList;
    }

    ConfigurationValueParser getParser() {
        return this.parser;
    }

    public String toString() {
        if (this.isList) {
            return "list of " + this.parser.description();
        }
        return this.parser.description();
    }

    private static boolean isEnum(Type argumentType) {
        return argumentType instanceof Class && ((Class)argumentType).isEnum();
    }

    static {
        HashMap map = new HashMap();
        map.put(String.class, new ConfigurationValueParser(){

            public Object parse(String value) {
                return value;
            }

            public String description() {
                return "string";
            }

            public String exampleValue() {
                return "<text>";
            }
        });
        map.put(Integer.class, new ConfigurationValueParser(){

            public Object parse(String value) {
                return Integer.parseInt(value);
            }

            public String description() {
                return "int";
            }

            public String exampleValue() {
                return "<int>";
            }
        });
        map.put(Long.class, new ConfigurationValueParser(){

            public Object parse(String value) {
                return Long.parseLong(value);
            }

            public String description() {
                return "long";
            }

            public String exampleValue() {
                return "<long>";
            }
        });
        map.put(Double.class, new ConfigurationValueParser(){

            public Object parse(String value) {
                return Double.parseDouble(value);
            }

            public String description() {
                return "double";
            }

            public String exampleValue() {
                return "<double>";
            }
        });
        map.put(Boolean.class, new ConfigurationValueParser(){

            public Object parse(String value) {
                return Boolean.parseBoolean(value);
            }

            public String description() {
                return "boolean";
            }

            public String exampleValue() {
                return "[false | true]";
            }
        });
        map.put(TypeName.class, new ConfigurationValueParser(){

            public Object parse(String value) {
                return TypeName.valueOf(value);
            }

            public String description() {
                return "type-name";
            }

            public String exampleValue() {
                return "<fully.qualified.Type>";
            }
        });
        SIMPLE_TYPES = map;
    }
}

