/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.kv.subdoc.multi;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.subdoc.multi.Lookup;
import com.couchbase.client.core.message.kv.subdoc.multi.Mutation;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;

@InterfaceStability.Committed
@InterfaceAudience.Public
public class MultiResult<OPERATION> {
    private final short statusCode;
    private final ResponseStatus status;
    private final String path;
    private final OPERATION operation;
    private final ByteBuf value;

    private MultiResult(short statusCode, ResponseStatus status, String path, OPERATION operation, ByteBuf value) {
        this.statusCode = statusCode;
        this.status = status;
        this.path = path;
        this.operation = operation;
        this.value = value;
    }

    public static MultiResult<Lookup> create(short statusCode, ResponseStatus status, String path, Lookup operation, ByteBuf value) {
        return new MultiResult<Lookup>(statusCode, status, path, operation, value);
    }

    public static MultiResult<Mutation> create(short statusCode, ResponseStatus status, String path, Mutation operation, ByteBuf value) {
        return new MultiResult<Mutation>(statusCode, status, path, operation, value);
    }

    public short statusCode() {
        return this.statusCode;
    }

    public ResponseStatus status() {
        return this.status;
    }

    public String path() {
        return this.path;
    }

    public OPERATION operation() {
        return this.operation;
    }

    public ByteBuf value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiResult that = (MultiResult)o;
        if (this.statusCode != that.statusCode) {
            return false;
        }
        if (this.status != that.status) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.operation != that.operation) {
            return false;
        }
        if (this.value == null) {
            return that.value == null;
        }
        return this.value.toString(CharsetUtil.UTF_8).equals(that.value.toString(CharsetUtil.UTF_8));
    }

    public int hashCode() {
        int result = this.statusCode;
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.operation != null ? this.operation.hashCode() : 0);
        if (this.value != null) {
            result = 31 * result + this.value.toString(CharsetUtil.UTF_8).hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.operation()).append('(').append(this.path()).append("): ").append((Object)this.status());
        if (this.value.readableBytes() > 0) {
            builder.append(" = ").append(this.value().toString(CharsetUtil.UTF_8));
        }
        return builder.toString();
    }
}

