/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataharvest.utils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.gcube.dataharvest.utils.AggregationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static Logger logger = LoggerFactory.getLogger(DateUtils.class);
    public static TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS Z";
    public static final DateFormat DEFAULT_DATE_FORMAT = DateUtils.getUTCDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");
    public static final String LAUNCH_DATE_FORMAT_PATTERN = "yyyy-MM-dd";
    public static final DateFormat LAUNCH_DATE_FORMAT = DateUtils.getUTCDateFormat("yyyy-MM-dd");
    public static final String UTC_DATE_FORMAT_PATTERN = "yyyy-MM-dd Z";
    public static final DateFormat UTC_DATE_FORMAT = DateUtils.getUTCDateFormat("yyyy-MM-dd Z");
    public static final String UTC = "+0000";

    public static DateFormat getUTCDateFormat(String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setTimeZone(UTC_TIMEZONE);
        return dateFormat;
    }

    public static Calendar getUTCCalendarInstance() {
        return Calendar.getInstance(UTC_TIMEZONE);
    }

    public static Calendar getPreviousPeriod(AggregationType aggregationType, boolean partialHarvesting) {
        Calendar now = DateUtils.getUTCCalendarInstance();
        switch (aggregationType) {
            case YEARLY: {
                if (!partialHarvesting) {
                    now.add(1, -1);
                }
                now.set(2, 0);
                now.set(5, 1);
                break;
            }
            case MONTHLY: {
                if (!partialHarvesting) {
                    now.add(2, -1);
                }
                now.set(5, 1);
                break;
            }
            case DAILY: {
                if (partialHarvesting) break;
                now.add(5, -1);
                break;
            }
        }
        now.set(11, 0);
        now.set(12, 0);
        now.set(13, 0);
        now.set(14, 0);
        return now;
    }

    public static Calendar getStartCalendar(int year, int month, int day) {
        Calendar aggregationStartCalendar = DateUtils.getUTCCalendarInstance();
        aggregationStartCalendar.set(1, year);
        aggregationStartCalendar.set(2, month);
        aggregationStartCalendar.set(5, day);
        aggregationStartCalendar.set(11, 0);
        aggregationStartCalendar.set(12, 0);
        aggregationStartCalendar.set(13, 0);
        aggregationStartCalendar.set(14, 0);
        logger.debug("{}", (Object)DEFAULT_DATE_FORMAT.format(aggregationStartCalendar.getTime()));
        return aggregationStartCalendar;
    }

    public static Date getEndDateFromStartDate(AggregationType aggregationType, Date startDate, int offset) {
        Calendar aggregationEndDate = DateUtils.getUTCCalendarInstance();
        aggregationEndDate.setTimeInMillis(startDate.getTime());
        aggregationEndDate.add(aggregationType.getCalendarField(), offset);
        return aggregationEndDate.getTime();
    }

    public static Calendar dateToCalendar(Date date) {
        Calendar calendar = DateUtils.getUTCCalendarInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static String format(Date date) {
        return LAUNCH_DATE_FORMAT.format(date);
    }

    public static String format(Calendar calendar) {
        return DateUtils.format(calendar.getTime());
    }

    public static String dateToStringWithTZ(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        return formatter.format(date) + "Z";
    }
}

