/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message;

import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import rx.subjects.AsyncSubject;
import rx.subjects.Subject;

public abstract class AbstractCouchbaseRequest
implements CouchbaseRequest {
    private final Subject<CouchbaseResponse, CouchbaseResponse> observable;
    private final String bucket;
    private final String username;
    private final String password;
    private final long creationTime;
    private volatile int retryCount;

    protected AbstractCouchbaseRequest(String bucket, String password) {
        this(bucket, bucket, password, AsyncSubject.create());
    }

    protected AbstractCouchbaseRequest(String bucket, String username, String password) {
        this(bucket, username, password, AsyncSubject.create());
    }

    protected AbstractCouchbaseRequest(String bucket, String username, String password, Subject<CouchbaseResponse, CouchbaseResponse> observable) {
        this.bucket = bucket;
        this.username = username;
        this.password = password;
        this.observable = observable;
        this.creationTime = System.nanoTime();
        this.retryCount = 0;
    }

    @Override
    public Subject<CouchbaseResponse, CouchbaseResponse> observable() {
        return this.observable;
    }

    @Override
    public String bucket() {
        return this.bucket;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public long creationTime() {
        return this.creationTime;
    }

    @Override
    public int incrementRetryCount() {
        return this.retryCount++;
    }

    @Override
    public int retryCount() {
        return this.retryCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "{");
        sb.append("observable=").append(this.observable);
        sb.append(", bucket='").append(this.bucket).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

