/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.restriction;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.security.AccessControlException;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.CompositePattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;

public class CompositeRestrictionProvider
implements RestrictionProvider {
    private final Collection<? extends RestrictionProvider> providers;

    private CompositeRestrictionProvider(@Nonnull Collection<? extends RestrictionProvider> providers) {
        this.providers = ImmutableSet.copyOf(providers);
    }

    public static RestrictionProvider newInstance(RestrictionProvider ... providers) {
        return CompositeRestrictionProvider.newInstance(Arrays.asList(providers));
    }

    public static RestrictionProvider newInstance(@Nonnull Collection<? extends RestrictionProvider> providers) {
        switch (providers.size()) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return providers.iterator().next();
            }
        }
        return new CompositeRestrictionProvider(providers);
    }

    @Override
    @Nonnull
    public Set<RestrictionDefinition> getSupportedRestrictions(@Nullable String oakPath) {
        HashSet<RestrictionDefinition> defs = Sets.newHashSet();
        for (RestrictionProvider restrictionProvider : this.providers) {
            defs.addAll(restrictionProvider.getSupportedRestrictions(oakPath));
        }
        return defs;
    }

    @Override
    @Nonnull
    public Restriction createRestriction(@Nullable String oakPath, @Nonnull String oakName, @Nonnull Value value) throws RepositoryException {
        return this.getProvider(oakPath, oakName).createRestriction(oakPath, oakName, value);
    }

    @Override
    @Nonnull
    public Restriction createRestriction(@Nullable String oakPath, @Nonnull String oakName, Value ... values) throws RepositoryException {
        return this.getProvider(oakPath, oakName).createRestriction(oakPath, oakName, values);
    }

    @Override
    @Nonnull
    public Set<Restriction> readRestrictions(@Nullable String oakPath, @Nonnull Tree aceTree) {
        HashSet<Restriction> restrictions = Sets.newHashSet();
        for (RestrictionProvider restrictionProvider : this.providers) {
            restrictions.addAll(restrictionProvider.readRestrictions(oakPath, aceTree));
        }
        return restrictions;
    }

    @Override
    public void writeRestrictions(String oakPath, Tree aceTree, Set<Restriction> restrictions) throws RepositoryException {
        for (Restriction r : restrictions) {
            RestrictionProvider rp = this.getProvider(oakPath, CompositeRestrictionProvider.getName(r));
            rp.writeRestrictions(oakPath, aceTree, Collections.singleton(r));
        }
    }

    @Override
    public void validateRestrictions(@Nullable String oakPath, @Nonnull Tree aceTree) throws RepositoryException {
        Map<String, RestrictionDefinition> supported = this.getSupported(oakPath);
        HashSet<String> rNames = new HashSet<String>();
        for (Restriction r : this.readRestrictions(oakPath, aceTree)) {
            String name = CompositeRestrictionProvider.getName(r);
            rNames.add(name);
            if (!supported.containsKey(name)) {
                throw new AccessControlException("Unsupported restriction: " + name + " at " + oakPath);
            }
            if (r.getDefinition().equals(supported.get(name))) continue;
            throw new AccessControlException("Invalid restriction: " + name + " at " + oakPath);
        }
        for (RestrictionDefinition def : supported.values()) {
            String defName = def.getName();
            if (CompositeRestrictionProvider.hasRestrictionProperty(aceTree, defName) && !rNames.contains(defName)) {
                throw new AccessControlException("Invalid restriction " + defName + " at " + oakPath);
            }
            if (!def.isMandatory() || rNames.contains(defName)) continue;
            throw new AccessControlException("Mandatory restriction " + defName + " is missing.");
        }
    }

    @Override
    @Nonnull
    public RestrictionPattern getPattern(@Nullable String oakPath, @Nonnull Tree tree) {
        ArrayList<RestrictionPattern> patterns = new ArrayList<RestrictionPattern>();
        for (RestrictionProvider restrictionProvider : this.providers) {
            RestrictionPattern pattern = restrictionProvider.getPattern(oakPath, tree);
            if (pattern == RestrictionPattern.EMPTY) continue;
            patterns.add(pattern);
        }
        switch (patterns.size()) {
            case 0: {
                return RestrictionPattern.EMPTY;
            }
            case 1: {
                return (RestrictionPattern)patterns.iterator().next();
            }
        }
        return new CompositePattern(patterns);
    }

    private RestrictionProvider getProvider(@Nullable String oakPath, @Nonnull String oakName) throws AccessControlException {
        for (RestrictionProvider restrictionProvider : this.providers) {
            for (RestrictionDefinition def : restrictionProvider.getSupportedRestrictions(oakPath)) {
                if (!def.getName().equals(oakName)) continue;
                return restrictionProvider;
            }
        }
        throw new AccessControlException("Unsupported restriction (path = " + oakPath + "; name = " + oakName + ')');
    }

    private Map<String, RestrictionDefinition> getSupported(@Nullable String oakPath) {
        HashMap<String, RestrictionDefinition> supported = new HashMap<String, RestrictionDefinition>();
        for (RestrictionProvider restrictionProvider : this.providers) {
            for (RestrictionDefinition rd : restrictionProvider.getSupportedRestrictions(oakPath)) {
                supported.put(rd.getName(), rd);
            }
        }
        return supported;
    }

    private static boolean hasRestrictionProperty(Tree aceTree, String name) {
        if (aceTree.hasProperty(name)) {
            return true;
        }
        Tree restrictionTree = aceTree.getChild("rep:restrictions");
        return restrictionTree.exists() && restrictionTree.hasProperty(name);
    }

    private static String getName(Restriction restriction) {
        return restriction.getDefinition().getName();
    }
}

