/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.versioning;

import com.thoughtworks.xstream.XStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRUserManager;
import org.gcube.common.homelibrary.jcr.workspace.util.TokenUtility;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRVersioning {
    private Logger logger = LoggerFactory.getLogger(JCRUserManager.class);
    Map<String, GCoreEndpoint.Profile.Endpoint> servlets = JCRRepository.servlets;

    public List<String> getVersioning(String id) throws InternalErrorException {
        List list = null;
        HttpMethodBase getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(this.servlets.get("History").uri().toString() + "?" + "id" + "=" + id);
            TokenUtility.setHeader((GetMethod)getMethod);
            httpClient.executeMethod(getMethod);
            this.logger.trace("Callin List Version History Servlet");
            XStream xstream = new XStream();
            list = (List)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error retrieving versioning for node " + id, (Throwable)e);
            throw new InternalErrorException(e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return list;
    }

    public void saveCurrentVersion(String id, String remotePath) throws InternalErrorException {
        this.logger.trace("Callin Update Version Servlet");
        HttpMethodBase getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(this.servlets.get("SaveCurrentVersion").uri().toString() + "?" + "id" + "=" + id + "&" + "remotePath" + "=" + remotePath);
            TokenUtility.setHeader((GetMethod)getMethod);
            int response = httpClient.executeMethod(getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
        }
        catch (Exception e) {
            this.logger.error("Error retrieving versioning for node " + id, (Throwable)e);
            throw new InternalErrorException(e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
    }

    public void restoreVersion(String id, String remotePath, String version) throws InternalErrorException {
        this.logger.trace("Callin List Version History Servlet");
        HttpMethodBase getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(this.servlets.get("RestoreVersion").uri().toString() + "?" + "id" + "=" + id + "&" + "remotePath" + "=" + remotePath + "&" + "version" + "=" + version);
            TokenUtility.setHeader((GetMethod)getMethod);
            int response = httpClient.executeMethod(getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
        }
        catch (Exception e) {
            this.logger.error("Error retrieving versioning for node " + id, (Throwable)e);
            throw new InternalErrorException(e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
    }
}

