/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntry;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionStore;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.security.authorization.permission.PrincipalPermissionEntries;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionStoreImpl
implements PermissionStore {
    private static final Logger log = LoggerFactory.getLogger(PermissionStoreImpl.class);
    private Tree permissionsTree;
    private final String workspaceName;
    private final RestrictionProvider restrictionProvider;
    private final Map<String, Tree> principalTreeMap = new HashMap<String, Tree>();

    public PermissionStoreImpl(Root root, String workspaceName, RestrictionProvider restrictionProvider) {
        this.permissionsTree = PermissionUtil.getPermissionsRoot(root, workspaceName);
        this.workspaceName = workspaceName;
        this.restrictionProvider = restrictionProvider;
    }

    protected void flush(Root root) {
        this.permissionsTree = PermissionUtil.getPermissionsRoot(root, this.workspaceName);
        this.principalTreeMap.clear();
    }

    @CheckForNull
    private Tree getPrincipalRoot(@Nonnull String principalName) {
        if (this.principalTreeMap.containsKey(principalName)) {
            return this.principalTreeMap.get(principalName);
        }
        Tree principalRoot = PermissionUtil.getPrincipalRoot(this.permissionsTree, principalName);
        if (!principalRoot.exists()) {
            principalRoot = null;
        }
        this.principalTreeMap.put(principalName, principalRoot);
        return principalRoot;
    }

    @Override
    @CheckForNull
    public Collection<PermissionEntry> load(@Nullable Collection<PermissionEntry> entries, @Nonnull String principalName, @Nonnull String path) {
        String name;
        Tree principalRoot = this.getPrincipalRoot(principalName);
        if (principalRoot != null && principalRoot.hasChild(name = PermissionUtil.getEntryName(path))) {
            Tree child = principalRoot.getChild(name);
            if (PermissionUtil.checkACLPath(child, path)) {
                entries = PermissionStoreImpl.loadPermissionEntries(path, entries, child, this.restrictionProvider);
            } else {
                for (Tree node : child.getChildren()) {
                    if (!PermissionUtil.checkACLPath(node, path)) continue;
                    entries = PermissionStoreImpl.loadPermissionEntries(path, entries, node, this.restrictionProvider);
                }
            }
        }
        return entries == null || entries.isEmpty() ? null : entries;
    }

    @Override
    public void load(@Nonnull Map<String, Collection<PermissionEntry>> entries, @Nonnull String principalName) {
        Tree principalRoot = this.getPrincipalRoot(principalName);
        if (principalRoot != null) {
            for (Tree entryTree : principalRoot.getChildren()) {
                PermissionStoreImpl.loadPermissionEntries(entryTree, entries, this.restrictionProvider);
            }
        }
    }

    @Override
    public long getNumEntries(@Nonnull String principalName, long max) {
        Tree tree = this.getPrincipalRoot(principalName);
        return tree == null ? 0L : tree.getChildrenCount(max);
    }

    @Override
    @Nonnull
    public PrincipalPermissionEntries load(@Nonnull String principalName) {
        long t0 = System.nanoTime();
        PrincipalPermissionEntries ret = new PrincipalPermissionEntries(principalName);
        Tree principalRoot = this.getPrincipalRoot(principalName);
        if (principalRoot != null) {
            for (Tree entryTree : principalRoot.getChildren()) {
                PermissionStoreImpl.loadPermissionEntries(entryTree, ret.getEntries(), this.restrictionProvider);
            }
        }
        ret.setFullyLoaded(true);
        long t1 = System.nanoTime();
        if (log.isDebugEnabled()) {
            log.debug(String.format("loaded %d entries in %.2fus for %s.%n", ret.getEntries().size(), (double)(t1 - t0) / 1000.0, principalName));
        }
        return ret;
    }

    private static void loadPermissionEntries(@Nonnull Tree tree, @Nonnull Map<String, Collection<PermissionEntry>> pathEntryMap, @Nonnull RestrictionProvider restrictionProvider) {
        String path = TreeUtil.getString(tree, "rep:accessControlledPath");
        Collection<PermissionEntry> entries = pathEntryMap.get(path);
        if (entries == null) {
            entries = new TreeSet<PermissionEntry>();
            pathEntryMap.put(path, entries);
        }
        for (Tree child : tree.getChildren()) {
            if (child.getName().charAt(0) == 'c') {
                PermissionStoreImpl.loadPermissionEntries(child, pathEntryMap, restrictionProvider);
                continue;
            }
            entries.add(new PermissionEntry(path, child, restrictionProvider));
        }
    }

    @CheckForNull
    private static Collection<PermissionEntry> loadPermissionEntries(@Nonnull String path, @Nullable Collection<PermissionEntry> ret, @Nonnull Tree tree, @Nonnull RestrictionProvider restrictionProvider) {
        for (Tree ace : tree.getChildren()) {
            if (ace.getName().charAt(0) == 'c') continue;
            if (ret == null) {
                ret = new TreeSet<PermissionEntry>();
            }
            ret.add(new PermissionEntry(path, ace, restrictionProvider));
        }
        return ret;
    }
}

