/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.ChannelSplitter;
import ij.plugin.PlugIn;
import ij.plugin.RGBStackMerge;
import ij.process.StackProcessor;
import ij.util.ThreadUtil;
import java.util.concurrent.atomic.AtomicInteger;

public class Filters3D
implements PlugIn {
    public static final int MEAN = 10;
    public static final int MEDIAN = 11;
    public static final int MIN = 12;
    public static final int MAX = 13;
    public static final int VAR = 14;
    public static final int MAXLOCAL = 15;
    private static float xradius = 2.0f;
    private static float yradius = 2.0f;
    private static float zradius = 2.0f;

    public void run(String arg) {
        String name = null;
        int filter = 0;
        if (arg.equals("mean")) {
            name = "3D Mean";
            filter = 10;
        } else if (arg.equals("median")) {
            name = "3D Median";
            filter = 11;
        } else if (arg.equals("min")) {
            name = "3D Minimum";
            filter = 12;
        } else if (arg.equals("max")) {
            name = "3D Maximum";
            filter = 13;
        } else if (arg.equals("var")) {
            name = "3D Variance";
            filter = 14;
        } else {
            return;
        }
        ImagePlus imp = IJ.getImage();
        if (imp.isComposite() && imp.getNChannels() == imp.getStackSize()) {
            IJ.error(name, "Composite color images not supported");
            return;
        }
        if (!this.showDialog(name)) {
            return;
        }
        imp.startTiming();
        this.run(imp, filter, xradius, yradius, zradius);
        IJ.showTime(imp, imp.getStartTime(), "", imp.getStackSize());
    }

    private boolean showDialog(String name) {
        GenericDialog gd = new GenericDialog(name);
        gd.addNumericField("X radius:", xradius, 1);
        gd.addNumericField("Y radius:", yradius, 1);
        gd.addNumericField("Z radius:", zradius, 1);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        xradius = (float)gd.getNextNumber();
        yradius = (float)gd.getNextNumber();
        zradius = (float)gd.getNextNumber();
        return true;
    }

    private void run(ImagePlus imp, int filter, float radX, float radY, float radZ) {
        ImageStack res = Filters3D.filter(imp.getStack(), filter, radX, radY, radZ);
        imp.setStack(res);
    }

    public static ImageStack filter(ImageStack stackorig, int filter, float vx, float vy, float vz) {
        if (stackorig.getBitDepth() == 24) {
            return Filters3D.filterRGB(stackorig, filter, vx, vy, vz);
        }
        final ImageStack stack = stackorig;
        final float voisx = vx;
        final float voisy = vy;
        final float voisz = vz;
        int width = stack.getWidth();
        int height = stack.getHeight();
        int depth = stack.getSize();
        ImageStack res = null;
        if (filter == 10 || filter == 11 || filter == 12 || filter == 13 || filter == 14) {
            res = filter == 14 ? ImageStack.create(width, height, depth, 32) : ImageStack.create(width, height, depth, stackorig.getBitDepth());
            IJ.showStatus("3D filtering...");
            final ImageStack out = res;
            final AtomicInteger ai = new AtomicInteger(0);
            final int n_cpus = Prefs.getThreads();
            final int f = filter;
            final int dec = (int)Math.ceil((double)stack.getSize() / (double)n_cpus);
            Thread[] threads = ThreadUtil.createThreadArray(n_cpus);
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(){

                    public void run() {
                        StackProcessor processor = new StackProcessor(stack);
                        int k = ai.getAndIncrement();
                        while (k < n_cpus) {
                            processor.filter3D(out, voisx, voisy, voisz, dec * k, dec * (k + 1), f);
                            k = ai.getAndIncrement();
                        }
                    }
                };
            }
            ThreadUtil.startAndJoin(threads);
        }
        return res;
    }

    private static ImageStack filterRGB(ImageStack rgb_in, int filter, float vx, float vy, float vz) {
        ImageStack[] channels = ChannelSplitter.splitRGB(rgb_in, false);
        ImageStack red = Filters3D.filter(channels[0], filter, vx, vy, vz);
        ImageStack green = Filters3D.filter(channels[1], filter, vx, vy, vz);
        ImageStack blue = Filters3D.filter(channels[2], filter, vx, vy, vz);
        return RGBStackMerge.mergeStacks(red, green, blue, false);
    }
}

