/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.gcube.contentmanagement.blobstorage.resource.MemoryType;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.DefaultMongoClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportManagerFactory {
    final Logger logger = LoggerFactory.getLogger(TransportManagerFactory.class);
    String[] server;
    String user;
    String password;

    public TransportManagerFactory(String[] server, String user, String password) {
        this.server = server;
        this.user = user;
        this.password = password;
    }

    public TransportManager getTransport(String backendType, MemoryType memoryType) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getOperation(String) - start");
        }
        Object tm = null;
        return this.load(backendType, memoryType);
    }

    private TransportManager load(String backendType, MemoryType memoryType) {
        ServiceLoader<TransportManager> loader = ServiceLoader.load(TransportManager.class);
        Iterator<TransportManager> iterator = loader.iterator();
        ArrayList<TransportManager> impls = new ArrayList<TransportManager>();
        while (iterator.hasNext()) {
            impls.add(iterator.next());
        }
        int implementationCounted = impls.size();
        if (implementationCounted == 0) {
            this.logger.info(" 0 implementation found. Load default implementation of TransportManager");
            return new DefaultMongoClient(this.server, this.user, this.password, memoryType);
        }
        if (implementationCounted == 1) {
            TransportManager tm = (TransportManager)impls.get(0);
            this.logger.info("1 implementation of TransportManager found. Load it. " + tm.getName());
            tm.initBackend(this.server, this.user, this.password, memoryType);
            return tm;
        }
        this.logger.info("found " + implementationCounted + " implementations of TransportManager");
        this.logger.info("search: " + backendType);
        for (TransportManager tm : impls) {
            if (!tm.getName().equalsIgnoreCase(backendType)) continue;
            this.logger.info("Found implementation " + backendType);
            return tm;
        }
        throw new IllegalStateException("Mismatch Backend Type and RuntimeResource Type. The backend type expected is " + backendType);
    }
}

