/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.insert.storage.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocialService {
    private static final String RESOURCE = "jersey-servlet";
    private static final String SERVICE_NAME = "SocialNetworking";
    private static final String SERVICE_CLASSE = "Portal";
    private static Logger logger = LoggerFactory.getLogger(SocialService.class);
    private String serviceBasePath;
    private static Map<String, SocialService> socialServicePerContext = new HashMap<String, SocialService>();

    public static SocialService getSocialService() throws Exception {
        Secret secret = SecretManagerProvider.get();
        String context = secret.getContext();
        SocialService socialService = socialServicePerContext.get(context);
        if (socialService == null) {
            socialService = new SocialService();
            socialServicePerContext.put(context, socialService);
        }
        return socialService;
    }

    private SocialService() throws Exception {
        this.getServiceBasePathViaGCoreEndpoint();
    }

    protected void getServiceBasePathViaGCoreEndpoint() throws Exception {
        Secret secret = SecretManagerProvider.get();
        String context = secret.getContext();
        try {
            XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
            query.addCondition("$resource/Profile/ServiceClass/text() eq '%s'".formatted(SERVICE_CLASSE));
            query.addCondition("$resource/Profile/DeploymentData/Status/text() eq 'ready'");
            query.addCondition("$resource/Profile/ServiceName/text() eq '%s'".formatted(SERVICE_NAME));
            query.setResult("$resource/Profile/AccessPoint/RunningInstanceInterfaces//Endpoint[@EntryName/string() eq \"jersey-servlet\"]/text()");
            DiscoveryClient client = ICFactory.client();
            List endpoints = client.submit((Query)query);
            if (endpoints == null || endpoints.isEmpty()) {
                throw new Exception("Cannot retrieve the GCoreEndpoint SERVICE_NAME: SocialNetworking, SERVICE_CLASSE: Portal, in scope: " + context);
            }
            this.serviceBasePath = (String)endpoints.get(0);
            if (this.serviceBasePath == null) {
                throw new Exception("Endpoint:jersey-servlet, is null for SERVICE_NAME: SocialNetworking, SERVICE_CLASSE: Portal, in scope: " + context);
            }
            this.serviceBasePath = this.serviceBasePath.endsWith("/") ? this.serviceBasePath : this.serviceBasePath + "/";
        }
        catch (Exception e) {
            String error = "An error occurred during GCoreEndpoint discovery, SERVICE_NAME: SocialNetworking, SERVICE_CLASSE: Portal, in scope: " + context + ".";
            logger.error(error, (Throwable)e);
            throw new Exception(error);
        }
    }

    public String getServiceBasePath() {
        return this.serviceBasePath;
    }
}

