/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree;

import com.google.common.base.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.tree.AbstractTree;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.ReadOnlyBuilder;

public final class ImmutableTree
extends AbstractTree {
    private final NodeState state;
    private final ParentProvider parentProvider;
    private String path;

    public ImmutableTree(@Nonnull NodeState rootState) {
        this(ParentProvider.ROOT_PROVIDER, "", rootState);
    }

    public ImmutableTree(@Nonnull ImmutableTree parent, @Nonnull String name, @Nonnull NodeState state) {
        this(new DefaultParentProvider(parent), name, state);
    }

    public ImmutableTree(@Nonnull ParentProvider parentProvider, @Nonnull String name, @Nonnull NodeState state) {
        super(name, new ReadOnlyBuilder(state));
        this.state = state;
        this.parentProvider = parentProvider;
    }

    @Override
    protected ImmutableTree createChild(String name) {
        return new ImmutableTree(this, name, this.state.getChildNode(name));
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            this.path = super.getPath();
        }
        return this.path;
    }

    @Override
    public boolean hasChild(String name) {
        return this.state.hasChildNode(name);
    }

    @Override
    public Tree.Status getStatus() {
        return Tree.Status.UNCHANGED;
    }

    @Override
    protected boolean isNew() {
        return false;
    }

    @Override
    protected boolean isModified() {
        return false;
    }

    @Override
    public ImmutableTree getParent() {
        return this.parentProvider.getParent();
    }

    @Override
    public Tree.Status getPropertyStatus(String name) {
        if (this.hasProperty(name)) {
            return Tree.Status.UNCHANGED;
        }
        return null;
    }

    @Override
    public ImmutableTree getChild(String name) {
        return this.createChild(name);
    }

    @Override
    public boolean remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Tree addChild(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOrderableChildren(boolean enable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean orderBefore(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperty(PropertyState property) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void setProperty(String name, T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void setProperty(String name, T value, Type<T> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeProperty(String name) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return Objects.hashCode(this.getName(), this.state);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImmutableTree) {
            ImmutableTree other = (ImmutableTree)o;
            return this.getName().equals(other.getName()) && this.state.equals(other.state);
        }
        return false;
    }

    public static final class DefaultParentProvider
    implements ParentProvider {
        private final ImmutableTree parent;

        DefaultParentProvider(@Nonnull ImmutableTree parent) {
            this.parent = parent;
        }

        @Override
        public ImmutableTree getParent() {
            return this.parent;
        }
    }

    public static interface ParentProvider {
        public static final ParentProvider UNSUPPORTED = new ParentProvider(){

            @Override
            public ImmutableTree getParent() {
                throw new UnsupportedOperationException("not supported.");
            }
        };
        public static final ParentProvider ROOT_PROVIDER = new ParentProvider(){

            @Override
            public ImmutableTree getParent() {
                throw new IllegalStateException("root tree does not have a parent");
            }
        };

        @CheckForNull
        public ImmutableTree getParent();
    }
}

