/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service.strategies;

import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.service.strategies.SelectionStrategy;
import com.couchbase.client.core.state.LifecycleState;

public class RoundRobinSelectionStrategy
implements SelectionStrategy {
    protected volatile int skip = 0;

    @Override
    public Endpoint select(CouchbaseRequest request, Endpoint[] endpoints) {
        Endpoint endpoint;
        int offset;
        int i;
        int endpointSize = endpoints.length;
        this.skip = Math.max(0, this.skip + 1);
        for (i = offset = this.skip % endpointSize; i < endpointSize; ++i) {
            endpoint = endpoints[i];
            if (!endpoint.isState(LifecycleState.CONNECTED)) continue;
            return endpoint;
        }
        for (i = 0; i < offset; ++i) {
            endpoint = endpoints[i];
            if (!endpoint.isState(LifecycleState.CONNECTED)) continue;
            return endpoint;
        }
        return null;
    }

    protected void setSkip(int newValue) {
        this.skip = newValue < 0 ? 0 : newValue;
    }
}

