/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.document;

import com.couchbase.client.core.message.kv.MutationToken;
import com.couchbase.client.java.document.AbstractDocument;
import com.couchbase.client.java.document.json.JsonObject;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class JsonDocument
extends AbstractDocument<JsonObject>
implements Serializable {
    private static final long serialVersionUID = 2050104986260610101L;

    public static JsonDocument create(String id) {
        return new JsonDocument(id, 0, null, 0L, null);
    }

    public static JsonDocument create(String id, JsonObject content) {
        return new JsonDocument(id, 0, content, 0L, null);
    }

    public static JsonDocument create(String id, JsonObject content, long cas) {
        return new JsonDocument(id, 0, content, cas, null);
    }

    public static JsonDocument create(String id, int expiry, JsonObject content) {
        return new JsonDocument(id, expiry, content, 0L, null);
    }

    public static JsonDocument create(String id, int expiry, JsonObject content, long cas) {
        return new JsonDocument(id, expiry, content, cas, null);
    }

    public static JsonDocument create(String id, int expiry, JsonObject content, long cas, MutationToken mutationToken) {
        return new JsonDocument(id, expiry, content, cas, mutationToken);
    }

    public static JsonDocument from(JsonDocument doc, String id) {
        return JsonDocument.create(id, doc.expiry(), (JsonObject)doc.content(), doc.cas(), doc.mutationToken());
    }

    public static JsonDocument from(JsonDocument doc, JsonObject content) {
        return JsonDocument.create(doc.id(), doc.expiry(), content, doc.cas(), doc.mutationToken());
    }

    public static JsonDocument from(JsonDocument doc, String id, JsonObject content) {
        return JsonDocument.create(id, doc.expiry(), content, doc.cas(), doc.mutationToken());
    }

    public static JsonDocument from(JsonDocument doc, long cas) {
        return JsonDocument.create(doc.id(), doc.expiry(), (JsonObject)doc.content(), cas, doc.mutationToken());
    }

    private JsonDocument(String id, int expiry, JsonObject content, long cas, MutationToken mutationToken) {
        super(id, expiry, content, cas, mutationToken);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.writeToSerializedStream(stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.readFromSerializedStream(stream);
    }
}

