/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoInternalException;
import com.mongodb.ServerAddress;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.internal.connection.SslHelper;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocket;

final class SocketStreamHelper {
    static void initialize(Socket socket, ServerAddress address, SocketSettings settings, SslSettings sslSettings) throws IOException {
        socket.setTcpNoDelay(true);
        socket.setSoTimeout(settings.getReadTimeout(TimeUnit.MILLISECONDS));
        socket.setKeepAlive(settings.isKeepAlive());
        if (settings.getReceiveBufferSize() > 0) {
            socket.setReceiveBufferSize(settings.getReceiveBufferSize());
        }
        if (settings.getSendBufferSize() > 0) {
            socket.setSendBufferSize(settings.getSendBufferSize());
        }
        if (sslSettings.isEnabled()) {
            if (!(socket instanceof SSLSocket)) {
                throw new MongoInternalException("SSL is enabled but the socket is not an instance of javax.net.ssl.SSLSocket");
            }
            if (!sslSettings.isInvalidHostNameAllowed()) {
                SSLSocket sslSocket = (SSLSocket)socket;
                sslSocket.setSSLParameters(SslHelper.enableHostNameVerification(sslSocket.getSSLParameters()));
            }
        }
        socket.connect(address.getSocketAddress(), settings.getConnectTimeout(TimeUnit.MILLISECONDS));
    }

    private SocketStreamHelper() {
    }
}

