/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.file;

import java.util.Comparator;

class TarEntry {
    static final Comparator<TarEntry> OFFSET_ORDER = new Comparator<TarEntry>(){

        @Override
        public int compare(TarEntry a, TarEntry b) {
            if (a.offset > b.offset) {
                return 1;
            }
            if (a.offset < b.offset) {
                return -1;
            }
            return 0;
        }
    };
    static final Comparator<TarEntry> IDENTIFIER_ORDER = new Comparator<TarEntry>(){

        @Override
        public int compare(TarEntry a, TarEntry b) {
            if (a.msb > b.msb) {
                return 1;
            }
            if (a.msb < b.msb) {
                return -1;
            }
            if (a.lsb > b.lsb) {
                return 1;
            }
            if (a.lsb < b.lsb) {
                return -1;
            }
            return 0;
        }
    };
    private final long msb;
    private final long lsb;
    private final int offset;
    private final int size;

    TarEntry(long msb, long lsb, int offset, int size) {
        this.msb = msb;
        this.lsb = lsb;
        this.offset = offset;
        this.size = size;
    }

    long msb() {
        return this.msb;
    }

    long lsb() {
        return this.lsb;
    }

    int offset() {
        return this.offset;
    }

    int size() {
        return this.size;
    }
}

