/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.util.Text;

public class MoveTracker {
    private List<MoveEntry> entries = new ArrayList<MoveEntry>();
    private Set<String> parentSourcePaths = new HashSet<String>();
    private Set<String> parentDestPaths = new HashSet<String>();

    public void addMove(@Nonnull String sourcePath, @Nonnull String destPath) {
        String originalSource = sourcePath;
        for (MoveEntry me : Lists.reverse(this.entries)) {
            if (!Text.isDescendantOrEqual(me.destPath, sourcePath)) continue;
            String relPath = PathUtils.relativize(me.destPath, sourcePath);
            if (!relPath.isEmpty()) {
                originalSource = me.sourcePath + '/' + relPath;
                break;
            }
            originalSource = me.sourcePath;
            break;
        }
        this.entries.add(new MoveEntry(originalSource, destPath));
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @CheckForNull
    public String getSourcePath(String destPath) {
        for (MoveEntry me : Lists.reverse(this.entries)) {
            if (!me.destPath.equals(destPath)) continue;
            return me.sourcePath;
        }
        return null;
    }

    @CheckForNull
    public String getDestPath(String sourcePath) {
        for (MoveEntry me : Lists.reverse(this.entries)) {
            if (!me.sourcePath.equals(sourcePath)) continue;
            return me.destPath;
        }
        return null;
    }

    public boolean containsMove(@CheckForNull String path) {
        if (path != null) {
            for (String p : Iterables.concat(this.parentSourcePaths, this.parentDestPaths)) {
                if (!Text.isDescendantOrEqual(path, p)) continue;
                return true;
            }
        }
        return false;
    }

    public void clear() {
        this.entries.clear();
        this.parentSourcePaths.clear();
        this.parentDestPaths.clear();
    }

    private final class MoveEntry {
        private final String sourcePath;
        private String destPath;

        private MoveEntry(@Nonnull String sourcePath, String destPath) {
            this.sourcePath = sourcePath;
            this.destPath = destPath;
            MoveTracker.this.parentSourcePaths.add(Text.getRelativeParent(sourcePath, 1));
            MoveTracker.this.parentDestPaths.add(Text.getRelativeParent(destPath, 1));
        }
    }
}

