/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.cluster;

import com.couchbase.client.java.bucket.BucketType;
import com.couchbase.client.java.cluster.BucketSettings;

public class DefaultBucketSettings
implements BucketSettings {
    private final String name;
    private final BucketType type;
    private final int quota;
    private final int port;
    private final String password;
    private final int replicas;
    private final boolean indexReplicas;
    private final boolean enableFlush;

    DefaultBucketSettings(Builder builder) {
        this.name = builder.name();
        this.type = builder.type();
        this.quota = builder.quota();
        this.port = builder.port();
        this.password = builder.password();
        this.replicas = builder.replicas();
        this.indexReplicas = builder.indexReplicas();
        this.enableFlush = builder.enableFlush();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public BucketType type() {
        return this.type;
    }

    @Override
    public int quota() {
        return this.quota;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public int replicas() {
        return this.replicas;
    }

    @Override
    public boolean indexReplicas() {
        return this.indexReplicas;
    }

    @Override
    public boolean enableFlush() {
        return this.enableFlush;
    }

    public String toString() {
        return "DefaultClusterBucketSettings{name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + ", quota=" + this.quota + ", port=" + this.port + ", password='" + this.password + '\'' + ", replicas=" + this.replicas + ", indexReplicas=" + this.indexReplicas + ", enableFlush=" + this.enableFlush + '}';
    }

    public static class Builder
    implements BucketSettings {
        private String name = "";
        private BucketType type = BucketType.COUCHBASE;
        private int quota = 0;
        private int port = 0;
        private String password = "";
        private int replicas = 0;
        private boolean indexReplicas = false;
        private boolean enableFlush = false;

        @Override
        public String name() {
            return this.name;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public BucketType type() {
            return this.type;
        }

        public Builder type(BucketType type) {
            this.type = type;
            return this;
        }

        @Override
        public int quota() {
            return this.quota;
        }

        public Builder quota(int quota) {
            this.quota = quota;
            return this;
        }

        @Override
        public int port() {
            return this.port;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        @Override
        public String password() {
            return this.password;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        @Override
        public int replicas() {
            return this.replicas;
        }

        public Builder replicas(int replicas) {
            this.replicas = replicas;
            return this;
        }

        @Override
        public boolean indexReplicas() {
            return this.indexReplicas;
        }

        public Builder indexReplicas(boolean indexReplicas) {
            this.indexReplicas = indexReplicas;
            return this;
        }

        @Override
        public boolean enableFlush() {
            return this.enableFlush;
        }

        public Builder enableFlush(boolean enableFlush) {
            this.enableFlush = enableFlush;
            return this;
        }

        public DefaultBucketSettings build() {
            return new DefaultBucketSettings(this);
        }
    }
}

