/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.whiteboard;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;

public abstract class AbstractServiceTracker<T> {
    private final Class<T> type;
    private Tracker<T> tracker = null;

    public AbstractServiceTracker(@Nonnull Class<T> type) {
        this.type = Preconditions.checkNotNull(type);
    }

    public synchronized void start(Whiteboard whiteboard) {
        Preconditions.checkState(this.tracker == null);
        this.tracker = whiteboard.track(this.type);
    }

    public synchronized void stop() {
        Preconditions.checkState(this.tracker != null);
        this.tracker.stop();
        this.tracker = null;
    }

    protected synchronized List<T> getServices() {
        Preconditions.checkState(this.tracker != null);
        return this.tracker.getServices();
    }
}

