/*
 * Decompiled with CFR 0.152.
 */
package org.jfile.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jfile.model.Glob;
import org.jfile.util.Parser;

public class GlobParser
implements Parser<Glob> {
    public static final String GLOB_FILE_LOCATION = "org/jfile/resources/globs";

    @Override
    public TreeMap<Integer, List<Glob>> parse() throws IOException {
        URL url = GlobParser.class.getClassLoader().getResource(GLOB_FILE_LOCATION);
        return this.parse(new File(url.getPath()));
    }

    @Override
    public TreeMap<Integer, List<Glob>> parse(File globFile) throws IOException {
        RandomAccessFile raf = null;
        TreeMap<Integer, List<Glob>> globs = new TreeMap<Integer, List<Glob>>();
        try {
            raf = new RandomAccessFile(globFile, "r");
            String globLine = raf.readLine();
            while (globLine != null) {
                if (globLine.length() <= 0 || globLine.startsWith("#")) {
                    globLine = raf.readLine();
                    continue;
                }
                String[] tokens = globLine.split(":");
                if (tokens.length != 2) {
                    globLine = raf.readLine();
                    continue;
                }
                Glob glob = GlobParser.toGlob(tokens[1], tokens[0]);
                List<Glob> list = globs.get(glob.getPriority());
                if (list == null) {
                    list = new ArrayList<Glob>();
                    globs.put(glob.getPriority(), list);
                }
                list.add(glob);
                globLine = raf.readLine();
            }
            TreeMap<Integer, List<Glob>> treeMap = globs;
            return treeMap;
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    private static Glob toGlob(String pattern, String type) {
        StringBuffer buffer = new StringBuffer();
        char[] chars = pattern.toCharArray();
        int i = 0;
        int len = chars.length;
        int priority = 50;
        int numWildCards = 0;
        int lastLiteralIdx = 0;
        while (i < len) {
            switch (chars[i]) {
                case '*': {
                    ++numWildCards;
                    buffer.append(".*");
                    lastLiteralIdx = ++i;
                    break;
                }
                case '?': {
                    ++numWildCards;
                    buffer.append('.');
                    lastLiteralIdx = ++i;
                    break;
                }
                case '[': {
                    ++numWildCards;
                    buffer.append(chars[i]);
                    if (++i < len) {
                        if (chars[i] == '!') {
                            buffer.append("^");
                            ++i;
                        } else if (chars[i] == ']') {
                            buffer.append(chars[i]);
                            ++i;
                        }
                        while (i < len && chars[i] != ']') {
                            if ("+()^$.{}[|\\&".indexOf(chars[i]) != -1) {
                                buffer.append("\\" + chars[i]);
                            } else {
                                buffer.append(chars[i]);
                            }
                            ++i;
                        }
                        if (i < len) {
                            buffer.append(chars[i]);
                            lastLiteralIdx = ++i;
                            break;
                        }
                        throw new PatternSyntaxException("Unclosed character class", pattern, i);
                    }
                    throw new PatternSyntaxException("Unclosed character class", pattern, i);
                }
                default: {
                    if ("+()^$.{}[]|\\&".indexOf(chars[i]) != -1) {
                        buffer.append("\\" + chars[i]);
                    } else {
                        buffer.append(chars[i]);
                    }
                    ++i;
                }
            }
        }
        if (numWildCards == 0) {
            priority += 50;
        } else {
            priority = numWildCards == 1 && pattern.startsWith(".*.") ? (priority += 20 + pattern.length()) : (priority += pattern.length());
            if (lastLiteralIdx != Integer.MAX_VALUE) {
                priority += pattern.length() - lastLiteralIdx;
            }
            if (priority >= 100) {
                priority = 99;
            }
        }
        Glob glob = new Glob();
        glob.setPattern(Pattern.compile(buffer.toString()));
        glob.setPriority(priority);
        glob.setType(type);
        return glob;
    }
}

