/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.implementations;

import java.io.Serializable;
import java.util.Map;
import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.SingleUsageRecord;
import org.gcube.accounting.datamodel.decorators.RequiredField;
import org.gcube.accounting.datamodel.validations.annotations.NotEmpty;
import org.gcube.accounting.datamodel.validations.annotations.NotEmptyIfNotNull;
import org.gcube.accounting.datamodel.validations.annotations.ValidIP;
import org.gcube.accounting.datamodel.validations.annotations.ValidInteger;
import org.gcube.accounting.datamodel.validations.annotations.ValidLong;
import org.gcube.accounting.datamodel.validations.annotations.ValidOperationType;
import org.gcube.accounting.exception.InvalidValueException;

public class StorageUsageRecord
extends BasicUsageRecord
implements SingleUsageRecord {
    private static final long serialVersionUID = 1381025822586583326L;
    @NotEmpty
    public static final String RESOURCE_OWNER = "resourceOwner";
    @NotEmptyIfNotNull
    public static final String PROVIDER_ID = "providerId";
    @NotEmptyIfNotNull
    public static final String OBJECT_URI = "objectURI";
    @RequiredField
    @ValidOperationType
    public static final String OPERATION_TYPE = "operationType";
    @NotEmpty
    public static final String QUALIFIER = "qualifier";
    @NotEmpty
    public static final String DATA_TYPE = "dataType";
    @ValidLong
    public static final String DATA_VOLUME = "dataVolume";
    @ValidInteger
    public static final String DATA_COUNT = "dataCount";
    @ValidIP
    public static final String CALLER_IP = "callerIP";

    public StorageUsageRecord() {
    }

    public StorageUsageRecord(Map<String, Serializable> properties) throws InvalidValueException {
        super(properties);
    }

    public String getResourceOwner() {
        return (String)this.resourceProperties.get(RESOURCE_OWNER);
    }

    public void setResourceOwner(String owner) throws InvalidValueException {
        this.setResourceProperty(RESOURCE_OWNER, (Serializable)((Object)owner));
    }

    public String getObjectURI() {
        return (String)this.resourceProperties.get(OBJECT_URI);
    }

    public void setObjectURI(String objectURI) throws InvalidValueException {
        this.setResourceProperty(OBJECT_URI, (Serializable)((Object)objectURI));
    }

    public String getOperationType() {
        return (String)this.resourceProperties.get(OPERATION_TYPE);
    }

    public void setOperationType(String operationType) throws InvalidValueException {
        this.setResourceProperty(OPERATION_TYPE, (Serializable)((Object)operationType));
    }

    public String getCallerIP() {
        return (String)this.resourceProperties.get(CALLER_IP);
    }

    public void setCallerIP(String callerIP) throws InvalidValueException {
        this.setResourceProperty(CALLER_IP, (Serializable)((Object)callerIP));
    }

    public String getProviderId() {
        return (String)this.resourceProperties.get(PROVIDER_ID);
    }

    public void setProviderId(String providerId) throws InvalidValueException {
        this.setResourceProperty(PROVIDER_ID, (Serializable)((Object)providerId));
    }

    public String getQualifier() {
        return (String)this.resourceProperties.get(QUALIFIER);
    }

    public void setQualifier(String qualifier) throws InvalidValueException {
        this.setResourceProperty(QUALIFIER, (Serializable)((Object)qualifier));
    }

    public String getDataType() {
        return (String)this.resourceProperties.get(DATA_TYPE);
    }

    public void setDataType(String dataType) throws InvalidValueException {
        this.setResourceProperty(DATA_TYPE, (Serializable)((Object)dataType));
    }

    public long getDataVolume() {
        return (Long)this.resourceProperties.get(DATA_VOLUME);
    }

    public void setDataVolume(long dataVolume) throws InvalidValueException {
        this.setResourceProperty(DATA_VOLUME, Long.valueOf(dataVolume));
    }

    public int getDataCount() {
        return (Integer)this.resourceProperties.get(DATA_COUNT);
    }

    public void setDataCount(int dataCount) throws InvalidValueException {
        this.setResourceProperty(DATA_COUNT, Integer.valueOf(dataCount));
    }

    public static enum OperationType {
        GET,
        PUT,
        UPDATE,
        DELETE;

    }
}

